/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.action.checkout.helper;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.archguard.action.checkout.GitCommandManager;
import org.archguard.action.checkout.GitSourceSettings;
import org.archguard.action.checkout.helper.GitAuthHelperKt;
import org.archguard.action.exec.Command;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u0000 %2\u00020\u0001:\u0001%B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0017J\u0006\u0010\u0019\u001a\u00020\nJ\u001c\u0010\u001a\u001a\u00020\u00172\n\b\u0002\u0010\u001b\u001a\u0004\u0018\u00010\n2\b\b\u0002\u0010\u001c\u001a\u00020\u001dJ\u001a\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\n2\b\b\u0002\u0010 \u001a\u00020\u001dH\u0002J\u0006\u0010!\u001a\u00020\u0017J\u0006\u0010\"\u001a\u00020\u0017J\u0006\u0010#\u001a\u00020\u0017J\u000e\u0010$\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006&"}, d2={"Lorg/archguard/action/checkout/helper/GitAuthHelper;", "", "git", "Lorg/archguard/action/checkout/GitCommandManager;", "settings", "Lorg/archguard/action/checkout/GitSourceSettings;", "(Lorg/archguard/action/checkout/GitCommandManager;Lorg/archguard/action/checkout/GitSourceSettings;)V", "getGit", "()Lorg/archguard/action/checkout/GitCommandManager;", "insteadOfKey", "", "insteadOfValues", "", "getSettings", "()Lorg/archguard/action/checkout/GitSourceSettings;", "sshCommand", "sshKeyPath", "sshKnownHostsPath", "temporaryHomePath", "tokenConfigKey", "tokenConfigValue", "tokenPlaceholderConfigValue", "configureAuth", "", "configureSsh", "configureTempGlobalConfig", "configureToken", "configPath", "globalConfig", "", "removeGitConfig", "configKey", "submoduleOnly", "removeGlobalConfig", "removeSsh", "removeToken", "replaceTokenPlaceholder", "Companion", "checkout"})
@SourceDebugExtension(value={"SMAP\nGitAuthHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GitAuthHelper.kt\norg/archguard/action/checkout/helper/GitAuthHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,248:1\n1#2:249\n*E\n"})
public final class GitAuthHelper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final GitCommandManager git;
    @NotNull
    private final GitSourceSettings settings;
    @NotNull
    private String tokenConfigKey;
    @NotNull
    private String tokenConfigValue;
    @NotNull
    private String tokenPlaceholderConfigValue;
    @NotNull
    private String insteadOfKey;
    @NotNull
    private final List<String> insteadOfValues;
    @NotNull
    private String sshCommand;
    @NotNull
    private String sshKeyPath;
    @NotNull
    private String sshKnownHostsPath;
    @NotNull
    private String temporaryHomePath;
    private static final Logger logger = LoggerFactory.getLogger(GitAuthHelper.class);

    public GitAuthHelper(@NotNull GitCommandManager git, @NotNull GitSourceSettings settings) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.git = git;
        this.settings = settings;
        this.tokenConfigKey = "";
        this.tokenConfigValue = "";
        this.tokenPlaceholderConfigValue = "";
        this.insteadOfKey = "";
        this.insteadOfValues = new ArrayList();
        this.sshCommand = "";
        this.sshKeyPath = "";
        this.sshKnownHostsPath = "";
        this.temporaryHomePath = "";
        URL serverUrl = new URL(this.settings.getGitServerUrl());
        this.tokenConfigKey = "http." + GitAuthHelperKt.access$origin(serverUrl) + "/.extraheader";
        Base64.Encoder encoder = Base64.getEncoder();
        String string = "x-access-token:" + this.settings.getAuthToken();
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        String basicCredential = encoder.encodeToString(byArray);
        this.tokenPlaceholderConfigValue = "AUTHORIZATION: basic ***";
        this.tokenConfigValue = "AUTHORIZATION: basic " + basicCredential;
        this.insteadOfKey = "url." + GitAuthHelperKt.access$origin(serverUrl) + "/.insteadOf";
        this.insteadOfValues.add("git@" + serverUrl.getHost() + ':');
    }

    @NotNull
    public final GitCommandManager getGit() {
        return this.git;
    }

    @NotNull
    public final GitSourceSettings getSettings() {
        return this.settings;
    }

    @NotNull
    public final String configureTempGlobalConfig() {
        boolean bl;
        if (((CharSequence)this.temporaryHomePath).length() > 0) {
            return this.temporaryHomePath + File.separator + ".gitconfig";
        }
        FileAttribute[] fileAttributeArray = new FileAttribute[]{};
        Path path = Files.createTempDirectory("archguard-action", Arrays.copyOf(fileAttributeArray, fileAttributeArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"createTempDirectory(prefix, *attributes)");
        String runnerTemp = ((Object)path.toAbsolutePath()).toString();
        boolean bl2 = bl = ((CharSequence)runnerTemp).length() > 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-GitAuthHelper$configureTempGlobalConfig$22 = false;
            String $i$a$-assert-GitAuthHelper$configureTempGlobalConfig$22 = "RUNNER_TEMP is not defined";
            throw new AssertionError((Object)$i$a$-assert-GitAuthHelper$configureTempGlobalConfig$22);
        }
        String string = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"randomUUID().toString()");
        String uniqueId = string;
        this.temporaryHomePath = runnerTemp + '/' + uniqueId;
        new File(this.temporaryHomePath).mkdirs();
        StringBuilder stringBuilder = new StringBuilder();
        String string2 = System.getenv("HOME");
        if (string2 == null) {
            string2 = System.getProperty("user.home");
        }
        String gitConfigPath = stringBuilder.append(string2).append("/.gitconfig").toString();
        String newGitConfigPath = this.temporaryHomePath + "/.gitconfig";
        boolean configExists = new File(gitConfigPath).exists();
        if (configExists) {
            logger.info("Copying '" + gitConfigPath + "' to '" + newGitConfigPath + '\'');
            CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
            Files.copy(Paths.get(gitConfigPath, new String[0]), Paths.get(newGitConfigPath, new String[0]), copyOptionArray);
        } else {
            FilesKt.writeText$default((File)new File(newGitConfigPath), (String)"", null, (int)2, null);
        }
        logger.info("Temporarily overriding HOME='" + this.temporaryHomePath + "' before making global git config changes");
        this.git.setEnvironmentVariable("HOME", this.temporaryHomePath);
        return newGitConfigPath;
    }

    public final void removeGlobalConfig() {
        if (((CharSequence)this.temporaryHomePath).length() > 0) {
            logger.info("Unsetting HOME override");
            this.git.removeEnvironmentVariable("HOME");
            FilesKt.deleteRecursively((File)new File(this.temporaryHomePath));
        }
    }

    public final void configureAuth() {
        this.removeSsh();
        this.removeToken();
        this.configureSsh();
        GitAuthHelper.configureToken$default(this, null, false, 3, null);
    }

    public final void configureSsh() {
        String string;
        String runnerTemp;
        boolean bl;
        if (((CharSequence)this.settings.getSshKey()).length() == 0) {
            return;
        }
        String string2 = System.getenv("RUNNER_TEMP");
        if (string2 == null) {
            string2 = "";
        }
        boolean bl2 = bl = ((CharSequence)(runnerTemp = string2)).length() > 0;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-GitAuthHelper$configureSsh$22 = false;
            String $i$a$-assert-GitAuthHelper$configureSsh$22 = "RUNNER_TEMP is not defined";
            throw new AssertionError((Object)$i$a$-assert-GitAuthHelper$configureSsh$22);
        }
        String string3 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"randomUUID().toString()");
        String uniqueId = string3;
        String[] $i$a$-assert-GitAuthHelper$configureSsh$22 = new String[]{uniqueId};
        this.sshKeyPath = ((Object)Paths.get(runnerTemp, $i$a$-assert-GitAuthHelper$configureSsh$22)).toString();
        new File(runnerTemp).mkdirs();
        FilesKt.writeText$default((File)new File(this.sshKeyPath), (String)(((Object)StringsKt.trim((CharSequence)this.settings.getSshKey())).toString() + '\n'), null, (int)2, null);
        if (GitAuthHelperKt.getIS_WINDOWS()) {
            String icacls = Shell.which$default((Shell)Shell.INSTANCE, (String)"icacls.exe", (boolean)false, (int)2, null);
            Command.Companion.exec$default((Command.Companion)Command.Companion, (String)(icacls + " \"" + this.sshKeyPath + "\" /grant:r \"" + System.getenv("USERDOMAIN") + '\\' + System.getenv("USERNAME") + ":F\""), null, null, (int)6, null);
            Command.Companion.exec$default((Command.Companion)Command.Companion, (String)(icacls + " \"" + this.sshKeyPath + "\" /inheritance:r"), null, null, (int)6, null);
        }
        String[] stringArray = new String[]{".ssh", "known_hosts"};
        String userKnownHostsPath = ((Object)Paths.get(System.getProperty("user.home"), stringArray)).toString();
        try {
            string = FilesKt.readText$default((File)new File(userKnownHostsPath), null, (int)1, null);
        }
        catch (Exception err) {
            if (err instanceof IOException || err instanceof SecurityException) {
                throw err;
            }
            string = "";
        }
        String userKnownHosts = string;
        String knownHosts = "";
        if (((CharSequence)userKnownHosts).length() > 0) {
            knownHosts = knownHosts + "# Begin from " + userKnownHostsPath + " \n" + userKnownHosts + " \n# End from " + userKnownHostsPath + " \n";
        }
        if (((CharSequence)this.settings.getSshKnownHosts()).length() > 0) {
            knownHosts = knownHosts + "# Begin from input known hosts \n" + this.settings.getSshKnownHosts() + " \n# end from input known hosts \n";
        }
        knownHosts = knownHosts + "# Begin implicitly added github.com \ngithub.com ssh-rsa AAAAB3NzaC1yc2EAAAABIwAAAQEAq2A7hRGmdnm9tUDbO9IDSwBK6TbQa+PXYPCPy6rbTrTtw7PHkccKrpp0yVhp5HdEIcKr6pLlVDBfOLX9QUsyCOV0wzfjIJNlGEYsdlLJizHhbn2mUjvSAHQqZETYP81eFzLQNnPHt4EVVUh7VfDESU84KezmD5QlWpXLmvU31/yMf+Se8xhHTvKSCZIFImWwoG6mbUoWf9nzpIoaSjB+weqqUUmpaaasXVal72J+UX2B+2RPW3RcT0eOzQgqlJL3RKrTJvdsjE3JEAvGq3lGHSZXy28G3skua2SmVi/w4yCE6gbODqnTWlg7+wC604ydGXA8VJiS5ap43JXiUFFAaQ== \n# End implicitly added github.com \n";
        String[] err = new String[]{uniqueId + "-known_hosts"};
        this.sshKnownHostsPath = ((Object)Paths.get(runnerTemp, err)).toString();
        FilesKt.writeText$default((File)new File(this.sshKnownHostsPath), (String)knownHosts, null, (int)2, null);
        String sshPath = Shell.which$default((Shell)Shell.INSTANCE, (String)"ssh", (boolean)false, (int)2, null);
        this.sshCommand = '\"' + sshPath + "\" -i \"" + this.sshKeyPath + '\"';
        if (this.settings.getSshStrict()) {
            this.sshCommand = this.sshCommand + " -o StrictHostKeyChecking=yes -o CheckHostIP=no";
        }
        this.sshCommand = this.sshCommand + " -o \"UserKnownHostsFile=" + this.sshKnownHostsPath + '\"';
        logger.info("Temporarily overriding GIT_SSH_COMMAND=" + this.sshCommand);
        this.git.setEnvironmentVariable("GIT_SSH_COMMAND", this.sshCommand);
        if (this.settings.getPersistCredentials()) {
            GitCommandManager.config$default(this.git, "core.sshCommand", this.sshCommand, false, false, 12, null);
        }
    }

    public final void configureToken(@Nullable String configPath, boolean globalConfig) {
        boolean bl;
        boolean bl2 = bl = configPath != null && globalConfig || configPath == null && !globalConfig;
        if (_Assertions.ENABLED && !bl) {
            boolean bl3 = false;
            String string = "Unexpected configureToken parameter combinations";
            throw new AssertionError((Object)string);
        }
        String defaultConfigPath = configPath;
        if (configPath == null && !globalConfig) {
            String[] stringArray = new String[]{".git", "config"};
            defaultConfigPath = ((Object)Paths.get(this.git.getWorkingDirectory(), stringArray)).toString();
        }
        GitCommandManager.config$default(this.git, this.tokenConfigKey, this.tokenPlaceholderConfigValue, globalConfig, false, 8, null);
        String string = defaultConfigPath;
        if (string == null) {
            string = "";
        }
        this.replaceTokenPlaceholder(string);
    }

    public static /* synthetic */ void configureToken$default(GitAuthHelper gitAuthHelper, String string, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            bl = false;
        }
        gitAuthHelper.configureToken(string, bl);
    }

    public final void replaceTokenPlaceholder(@NotNull String configPath) {
        Intrinsics.checkNotNullParameter((Object)configPath, (String)"configPath");
        String content = FilesKt.readText$default((File)new File(configPath), null, (int)1, null);
        int placeholderIndex = StringsKt.indexOf$default((CharSequence)content, (String)this.tokenPlaceholderConfigValue, (int)0, (boolean)false, (int)6, null);
        if (placeholderIndex < 0 || placeholderIndex != StringsKt.lastIndexOf$default((CharSequence)content, (String)this.tokenPlaceholderConfigValue, (int)0, (boolean)false, (int)6, null)) {
            throw new Error("Unable to replace auth placeholder in " + configPath);
        }
        String contentReplaced = StringsKt.replace$default((String)content, (String)this.tokenPlaceholderConfigValue, (String)this.tokenConfigValue, (boolean)false, (int)4, null);
        FilesKt.writeText$default((File)new File(configPath), (String)contentReplaced, null, (int)2, null);
    }

    public final void removeSsh() {
        String knownHostsPath;
        String keyPath = this.sshKeyPath;
        if (((CharSequence)keyPath).length() > 0) {
            try {
                FilesKt.deleteRecursively((File)new File(keyPath));
            }
            catch (Exception err) {
                logger.info(err.getMessage());
                logger.info("Failed to remove SSH key '" + keyPath + '\'');
            }
        }
        if (((CharSequence)(knownHostsPath = this.sshKnownHostsPath)).length() > 0) {
            try {
                FilesKt.deleteRecursively((File)new File(knownHostsPath));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        GitAuthHelper.removeGitConfig$default(this, "core.sshCommand", false, 2, null);
    }

    public final void removeToken() {
        GitAuthHelper.removeGitConfig$default(this, this.tokenConfigKey, false, 2, null);
    }

    private final void removeGitConfig(String configKey, boolean submoduleOnly) {
        if (!submoduleOnly && GitCommandManager.configExists$default(this.git, configKey, false, 2, null) && !GitCommandManager.tryConfigUnset$default(this.git, configKey, false, 2, null)) {
            logger.info("Failed to remove '" + configKey + "' from the git config");
        }
        CharSequence charSequence = configKey;
        Regex regex = new Regex("[.*+?^$()|\\[\\]\\\\]");
        String string = "\\$0";
        String pattern = regex.replace(charSequence, string);
        this.git.submoduleForeach("sh -c \"git config --local --name-only --get-regexp '" + pattern + "' && git config --local --unset-all '" + configKey + "' || :\"", true);
    }

    static /* synthetic */ void removeGitConfig$default(GitAuthHelper gitAuthHelper, String string, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        gitAuthHelper.removeGitConfig(string, bl);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lorg/archguard/action/checkout/helper/GitAuthHelper$Companion;", "", "()V", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "getLogger", "()Lorg/slf4j/Logger;", "checkout"})
    public static final class Companion {
        private Companion() {
        }

        public final Logger getLogger() {
            return logger;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

