/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.action.checkout.helper;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.archguard.action.checkout.GitCommandManager;
import org.archguard.action.checkout.helper.CheckoutInfo;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00040\u000e2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004R\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000f"}, d2={"Lorg/archguard/action/checkout/helper/RefHelper;", "", "()V", "tagsRefSpec", "", "getTagsRefSpec", "()Ljava/lang/String;", "getCheckoutInfo", "Lorg/archguard/action/checkout/helper/CheckoutInfo;", "git", "Lorg/archguard/action/checkout/GitCommandManager;", "ref", "commit", "getRefSpecForAllHistory", "", "checkout"})
public final class RefHelper {
    @NotNull
    private final String tagsRefSpec;

    public RefHelper() {
        this.tagsRefSpec = "+refs/tags/*:refs/tags/*";
    }

    @NotNull
    public final String getTagsRefSpec() {
        return this.tagsRefSpec;
    }

    @NotNull
    public final List<String> getRefSpecForAllHistory(@NotNull String ref, @NotNull String commit) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        List result = new ArrayList();
        result.add("+refs/heads/*:refs/remotes/origin/*");
        result.add(this.tagsRefSpec);
        if (((CharSequence)ref).length() > 0) {
            String string = ref;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
            if (StringsKt.startsWith$default((String)string2, (String)"REFS/PULL/", (boolean)false, (int)2, null)) {
                String string3 = ref.substring(10);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                String branch = string3;
                result.add('+' + commit + ":refs/remotes/pull/" + branch);
            }
        }
        return result;
    }

    @NotNull
    public final CheckoutInfo getCheckoutInfo(@NotNull GitCommandManager git, @NotNull String ref, @NotNull String commit) {
        Intrinsics.checkNotNullParameter((Object)git, (String)"git");
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        Intrinsics.checkNotNullParameter((Object)commit, (String)"commit");
        CheckoutInfo result = new CheckoutInfo(null, null, 3, null);
        if (((CharSequence)ref).length() == 0) {
            result.setRef(commit);
        } else {
            String branch;
            String string = ref;
            Locale locale = Locale.getDefault();
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"getDefault()");
            String string2 = string.toUpperCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toUpperCase(locale)");
            if (StringsKt.startsWith$default((String)string2, (String)"REFS/HEADS/", (boolean)false, (int)2, null)) {
                String string3 = ref.substring(11);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
                branch = string3;
                result.setRef(branch);
                result.setStartPoint("refs/remotes/origin/" + branch);
            } else {
                branch = ref;
                Locale locale2 = Locale.getDefault();
                Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"getDefault()");
                String string4 = branch.toUpperCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).toUpperCase(locale)");
                if (StringsKt.startsWith$default((String)string4, (String)"REFS/PULL/", (boolean)false, (int)2, null)) {
                    String string5 = ref.substring(10);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                    branch = string5;
                    result.setRef("refs/remotes/pull/" + branch);
                } else {
                    string = ref;
                    Locale locale3 = Locale.getDefault();
                    Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"getDefault()");
                    String string6 = string.toUpperCase(locale3);
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"this as java.lang.String).toUpperCase(locale)");
                    if (StringsKt.startsWith$default((String)string6, (String)"REFS/", (boolean)false, (int)2, null)) {
                        result.setRef(ref);
                    } else if (git.branchExists(true, "origin/" + ref)) {
                        result.setRef(ref);
                        result.setStartPoint("refs/remotes/origin/" + ref);
                    } else if (git.tagExists(ref)) {
                        result.setRef("refs/tags/" + ref);
                    } else {
                        throw new Exception("A branch or tag with the name '" + ref + "' could not be found");
                    }
                }
            }
        }
        return result;
    }
}

