/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.architecture.detect;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.archguard.architecture.core.CodeStructureStyle;
import org.archguard.architecture.detect.DddLayeredChecker;
import org.archguard.architecture.detect.MvcLayeredIdentify;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/archguard/architecture/detect/LayeredIdentify;", "", "packages", "", "", "(Ljava/util/List;)V", "ddd", "Lorg/archguard/architecture/detect/DddLayeredChecker;", "mvc", "Lorg/archguard/architecture/detect/MvcLayeredIdentify;", "identify", "Lorg/archguard/architecture/core/CodeStructureStyle;", "analyser_architecture"})
@SourceDebugExtension(value={"SMAP\nLayeredIdentify.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LayeredIdentify.kt\norg/archguard/architecture/detect/LayeredIdentify\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,94:1\n1855#2,2:95\n*S KotlinDebug\n*F\n+ 1 LayeredIdentify.kt\norg/archguard/architecture/detect/LayeredIdentify\n*L\n79#1:95,2\n*E\n"})
public final class LayeredIdentify {
    @NotNull
    private final List<String> packages;
    @NotNull
    private DddLayeredChecker ddd;
    @NotNull
    private MvcLayeredIdentify mvc;

    public LayeredIdentify(@NotNull List<String> packages) {
        Intrinsics.checkNotNullParameter(packages, (String)"packages");
        this.packages = packages;
        this.ddd = new DddLayeredChecker();
        this.mvc = new MvcLayeredIdentify();
    }

    @NotNull
    public final CodeStructureStyle identify() {
        Iterable $this$forEach$iv = this.packages;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            this.ddd.addToIdentify(it);
            this.mvc.addToIdentify(it);
        }
        if (this.ddd.canMarked()) {
            return CodeStructureStyle.DDD;
        }
        if (this.mvc.canMarked()) {
            return CodeStructureStyle.MVC;
        }
        return CodeStructureStyle.UNKNOWN;
    }
}

