/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.ignore;

import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.archguard.scanner.analyser.ignore.IgnorePathMatcher;
import org.archguard.scanner.analyser.ignore.IgnorePathMatcherKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\n"}, d2={"Lorg/archguard/scanner/analyser/ignore/FilepathMatcherIgnore;", "Lorg/archguard/scanner/analyser/ignore/IgnorePathMatcher;", "path", "", "(Ljava/lang/String;)V", "getPath", "()Ljava/lang/String;", "match", "", "Companion", "analyser_estimate"})
public final class FilepathMatcherIgnore
implements IgnorePathMatcher {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String path;

    public FilepathMatcherIgnore(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.path = path;
    }

    @NotNull
    public final String getPath() {
        return this.path;
    }

    @Override
    public boolean match(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Path absolute = IgnorePathMatcherKt.getFileSystem().getPath(path, new String[0]);
        return IgnorePathMatcherKt.getFileSystem().getPathMatcher("glob:" + this.path).matches(absolute);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0004\u00a8\u0006\u0006"}, d2={"Lorg/archguard/scanner/analyser/ignore/FilepathMatcherIgnore$Companion;", "", "()V", "convertGlobToRegex", "", "glob", "analyser_estimate"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String convertGlobToRegex(@NotNull String glob) {
            Intrinsics.checkNotNullParameter((Object)glob, (String)"glob");
            boolean inDoubleQuotes = false;
            StringBuilder regex = new StringBuilder("^");
            boolean escaping = false;
            boolean inClass = false;
            char[] cArray = glob.toCharArray();
            Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"this as java.lang.String).toCharArray()");
            for (char current : cArray) {
                if (escaping) {
                    regex.append(current);
                    escaping = false;
                    continue;
                }
                if (current == '\\') {
                    escaping = true;
                    if (!inClass) continue;
                    regex.append("\\\\");
                    continue;
                }
                if (current == '*') {
                    regex.append(inClass ? "*" : ".*");
                    continue;
                }
                if (current == '?') {
                    regex.append(inClass ? "?" : ".");
                    continue;
                }
                if (current == '[') {
                    inClass = true;
                    regex.append("[");
                    continue;
                }
                if (current == ']') {
                    inClass = false;
                    regex.append("]");
                    continue;
                }
                if (current == '.') {
                    regex.append("\\.");
                    continue;
                }
                if (current == '/') {
                    regex.append("/");
                    continue;
                }
                if (current == '{') {
                    regex.append("(");
                    continue;
                }
                if (current == '}') {
                    regex.append(")");
                    continue;
                }
                if (current == ',') {
                    regex.append("|");
                    continue;
                }
                if (current == '\"') {
                    regex.append("\"");
                    continue;
                }
                regex.append(current);
            }
            String string = regex.append('$').toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"regex.append('$').toString()");
            return string;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

