/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.ignore;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.archguard.scanner.analyser.ignore.FilepathMatcherIgnore;
import org.archguard.scanner.analyser.ignore.IgnorePathMatcher;
import org.archguard.scanner.analyser.ignore.IgnoreUtilKt;
import org.archguard.scanner.analyser.ignore.SimpleMatcherIgnore;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u0000  2\u00020\u0001:\u0001 B5\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\b\b\u0002\u0010\t\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001cJ\u0016\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0003R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\f\"\u0004\b\u0010\u0010\u000eR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\t\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\f\"\u0004\b\u0016\u0010\u000eR\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001a\u00a8\u0006!"}, d2={"Lorg/archguard/scanner/analyser/ignore/Pattern;", "", "hasRootPrefix", "", "hasDirSuffix", "pathDepth", "", "matcher", "Lorg/archguard/scanner/analyser/ignore/IgnorePathMatcher;", "onlyEqualizedPath", "(ZZILorg/archguard/scanner/analyser/ignore/IgnorePathMatcher;Z)V", "getHasDirSuffix", "()Z", "setHasDirSuffix", "(Z)V", "getHasRootPrefix", "setHasRootPrefix", "getMatcher", "()Lorg/archguard/scanner/analyser/ignore/IgnorePathMatcher;", "setMatcher", "(Lorg/archguard/scanner/analyser/ignore/IgnorePathMatcher;)V", "getOnlyEqualizedPath", "setOnlyEqualizedPath", "getPathDepth", "()I", "setPathDepth", "(I)V", "equalizeDepth", "", "path", "match", "isDir", "Companion", "analyser_estimate"})
public final class Pattern {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private boolean hasRootPrefix;
    private boolean hasDirSuffix;
    private int pathDepth;
    @NotNull
    private IgnorePathMatcher matcher;
    private boolean onlyEqualizedPath;

    public Pattern(boolean hasRootPrefix, boolean hasDirSuffix, int pathDepth, @NotNull IgnorePathMatcher matcher, boolean onlyEqualizedPath) {
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        this.hasRootPrefix = hasRootPrefix;
        this.hasDirSuffix = hasDirSuffix;
        this.pathDepth = pathDepth;
        this.matcher = matcher;
        this.onlyEqualizedPath = onlyEqualizedPath;
    }

    public /* synthetic */ Pattern(boolean bl, boolean bl2, int n, IgnorePathMatcher ignorePathMatcher, boolean bl3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            bl = false;
        }
        if ((n2 & 2) != 0) {
            bl2 = false;
        }
        if ((n2 & 4) != 0) {
            n = 0;
        }
        if ((n2 & 0x10) != 0) {
            bl3 = false;
        }
        this(bl, bl2, n, ignorePathMatcher, bl3);
    }

    public final boolean getHasRootPrefix() {
        return this.hasRootPrefix;
    }

    public final void setHasRootPrefix(boolean bl) {
        this.hasRootPrefix = bl;
    }

    public final boolean getHasDirSuffix() {
        return this.hasDirSuffix;
    }

    public final void setHasDirSuffix(boolean bl) {
        this.hasDirSuffix = bl;
    }

    public final int getPathDepth() {
        return this.pathDepth;
    }

    public final void setPathDepth(int n) {
        this.pathDepth = n;
    }

    @NotNull
    public final IgnorePathMatcher getMatcher() {
        return this.matcher;
    }

    public final void setMatcher(@NotNull IgnorePathMatcher ignorePathMatcher) {
        Intrinsics.checkNotNullParameter((Object)ignorePathMatcher, (String)"<set-?>");
        this.matcher = ignorePathMatcher;
    }

    public final boolean getOnlyEqualizedPath() {
        return this.onlyEqualizedPath;
    }

    public final void setOnlyEqualizedPath(boolean bl) {
        this.onlyEqualizedPath = bl;
    }

    public final boolean match(@NotNull String path, boolean isDir) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        if (this.hasDirSuffix && !isDir) {
            return false;
        }
        String targetPath = this.hasRootPrefix || this.onlyEqualizedPath ? path : this.equalizeDepth(path);
        return this.matcher.match(targetPath);
    }

    @NotNull
    public final String equalizeDepth(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String equalizedPath = (String)IgnoreUtilKt.cutLastN(path, this.pathDepth + 1).component1();
        return equalizedPath;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u000e\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\b"}, d2={"Lorg/archguard/scanner/analyser/ignore/Pattern$Companion;", "", "()V", "newPattern", "Lorg/archguard/scanner/analyser/ignore/Pattern;", "path", "", "newPatternForEqualizedPath", "analyser_estimate"})
    @SourceDebugExtension(value={"SMAP\nPattern.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Pattern.kt\norg/archguard/scanner/analyser/ignore/Pattern$Companion\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,60:1\n1099#2,3:61\n*S KotlinDebug\n*F\n+ 1 Pattern.kt\norg/archguard/scanner/analyser/ignore/Pattern$Companion\n*L\n35#1:61,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Pattern newPattern(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            boolean hasRootPrefix = path.charAt(0) == '/';
            boolean hasDirSuffix = path.charAt(path.length() - 1) == '/';
            int pathDepth = 0;
            if (!hasRootPrefix) {
                CharSequence $this$count$iv = path;
                boolean $i$f$count = false;
                int count$iv = 0;
                for (int i = 0; i < $this$count$iv.length(); ++i) {
                    char element$iv;
                    char it = element$iv = $this$count$iv.charAt(i);
                    boolean bl = false;
                    if (!(it == '/')) continue;
                    ++count$iv;
                }
                pathDepth = count$iv;
            }
            IgnorePathMatcher matcher = null;
            char[] cArray = new char[]{'/'};
            String matchingPath = StringsKt.trim((String)path, (char[])cArray);
            matcher = IgnoreUtilKt.hasMeta(path) ? (IgnorePathMatcher)new FilepathMatcherIgnore(matchingPath) : (IgnorePathMatcher)new SimpleMatcherIgnore(matchingPath);
            return new Pattern(hasRootPrefix, hasDirSuffix, pathDepth, matcher, false, 16, null);
        }

        @NotNull
        public final Pattern newPatternForEqualizedPath(@NotNull String path) {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Pattern pattern = this.newPattern(path);
            pattern.setOnlyEqualizedPath(true);
            return pattern;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

