/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.archguard.scanner.analyser.sca.gomod.GoModFinder;
import org.archguard.scanner.analyser.sca.gradle.GradleFinder;
import org.archguard.scanner.analyser.sca.maven.MavenFinder;
import org.archguard.scanner.analyser.sca.npm.NpmFinder;
import org.archguard.scanner.core.client.ArchGuardClient;
import org.archguard.scanner.core.sca.CompositionDependency;
import org.archguard.scanner.core.sca.DependencyEntry;
import org.archguard.scanner.core.sca.PackageDependencies;
import org.archguard.scanner.core.sca.ScaContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fH\u0016J\u0012\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\f*\u00020\u000fH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/archguard/scanner/analyser/ScaAnalyser;", "Lorg/archguard/scanner/core/sca/ScaAnalyser;", "context", "Lorg/archguard/scanner/core/sca/ScaContext;", "(Lorg/archguard/scanner/core/sca/ScaContext;)V", "client", "Lorg/archguard/scanner/core/client/ArchGuardClient;", "getContext", "()Lorg/archguard/scanner/core/sca/ScaContext;", "path", "", "analyse", "", "Lorg/archguard/scanner/core/sca/CompositionDependency;", "toCompositionDependency", "Lorg/archguard/scanner/core/sca/PackageDependencies;", "analyser_sca"})
@SourceDebugExtension(value={"SMAP\nScaAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScaAnalyser.kt\norg/archguard/scanner/analyser/ScaAnalyser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,60:1\n1360#2:61\n1446#2,5:62\n1360#2:67\n1446#2,5:68\n1360#2:73\n1446#2,5:74\n1549#2:79\n1620#2,3:80\n*S KotlinDebug\n*F\n+ 1 ScaAnalyser.kt\norg/archguard/scanner/analyser/ScaAnalyser\n*L\n22#1:61\n22#1:62,5\n28#1:67\n28#1:68,5\n33#1:73\n33#1:74,5\n43#1:79\n43#1:80,3\n*E\n"})
public final class ScaAnalyser
implements org.archguard.scanner.core.sca.ScaAnalyser {
    @NotNull
    private final ScaContext context;
    @NotNull
    private final ArchGuardClient client;
    @NotNull
    private final String path;

    public ScaAnalyser(@NotNull ScaContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.client = this.getContext().getClient();
        this.path = this.getContext().getPath();
    }

    @NotNull
    public ScaContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<CompositionDependency> analyse() {
        Object object;
        List list;
        switch (this.getContext().getLanguage()) {
            case "java": 
            case "kotlin": {
                Iterable $this$flatMapTo$iv$iv;
                List depDeclarations = CollectionsKt.toMutableList((Collection)new GradleFinder().process(this.path));
                CollectionsKt.addAll((Collection)depDeclarations, (Iterable)new MavenFinder().process(this.path));
                Iterable $this$flatMap$iv = depDeclarations;
                boolean $i$f$flatMap = false;
                Iterable iterable = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PackageDependencies it = (PackageDependencies)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = this.toCompositionDependency(it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                break;
            }
            case "typescript": 
            case "javascript": {
                List depDeclarations = new NpmFinder().process(this.path);
                Iterable $this$flatMap$iv = depDeclarations;
                boolean $i$f$flatMap2 = false;
                Iterable $this$flatMapTo$iv$iv = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PackageDependencies it = (PackageDependencies)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = this.toCompositionDependency(it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                break;
            }
            case "golang": {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv = CollectionsKt.toMutableList((Collection)new GoModFinder().process(this.path));
                boolean $i$f$flatMap = false;
                Iterable $i$f$flatMap2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    PackageDependencies it = (PackageDependencies)element$iv$iv;
                    boolean bl = false;
                    Iterable list$iv$iv = this.toCompositionDependency(it);
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported language: " + this.getContext().getLanguage());
            }
        }
        Object it = object = list;
        boolean bl = false;
        this.client.saveDependencies((List)it);
        return object;
    }

    /*
     * WARNING - void declaration
     */
    private final List<CompositionDependency> toCompositionDependency(PackageDependencies $this$toCompositionDependency) {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toCompositionDependency.getDependencies();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            DependencyEntry dependencyEntry = (DependencyEntry)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = UUID.randomUUID().toString();
            String string2 = $this$toCompositionDependency.getName();
            String string3 = $this$toCompositionDependency.getVersion();
            String string4 = $this$toCompositionDependency.getPath();
            String string5 = $this$toCompositionDependency.getPackageManager();
            String string6 = it.getName();
            String string7 = it.getArtifact();
            String string8 = it.getGroup();
            String string9 = it.getScope().toString();
            String string10 = it.getVersion();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString()");
            collection.add(new CompositionDependency(string, string2, string4, string3, "", string5, string6, string8, string7, null, null, string9, string10, 1536, null));
        }
        return (List)destination$iv$iv;
    }
}

