/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.sca.gradle;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.archguard.scanner.analyser.sca.base.Parser;
import org.archguard.scanner.analyser.sca.gradle.GradleParser;
import org.archguard.scanner.analyser.sca.gradle.GradleParserKt;
import org.archguard.scanner.core.sca.DEP_SCOPE;
import org.archguard.scanner.core.sca.DeclFileTree;
import org.archguard.scanner.core.sca.DependencyEntry;
import org.archguard.scanner.core.sca.PackageDependencies;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0016\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0016\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0016\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0005H\u0002J\u0018\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u00052\u0006\u0010\u0017\u001a\u00020\u0005H\u0002R&\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\n\u00a8\u0006\u001a"}, d2={"Lorg/archguard/scanner/analyser/sca/gradle/GradleParser;", "Lorg/archguard/scanner/analyser/sca/base/Parser;", "()V", "versionCatalogs", "", "", "Lorg/archguard/scanner/core/sca/DependencyEntry;", "getVersionCatalogs", "()Ljava/util/Map;", "setVersionCatalogs", "(Ljava/util/Map;)V", "lookupSource", "", "Lorg/archguard/scanner/core/sca/PackageDependencies;", "file", "Lorg/archguard/scanner/core/sca/DeclFileTree;", "parseDependencySet", "content", "parseKeywordArg", "parseShortForm", "parseVersionCatalog", "scopeForGradle", "Lorg/archguard/scanner/core/sca/DEP_SCOPE;", "text", "valueFromRegex", "key", "analyser_sca"})
@SourceDebugExtension(value={"SMAP\nGradleParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleParser.kt\norg/archguard/scanner/analyser/sca/gradle/GradleParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,210:1\n1603#2,9:211\n1855#2:220\n1856#2:222\n1612#2:223\n1549#2:224\n1620#2,3:225\n1#3:221\n*S KotlinDebug\n*F\n+ 1 GradleParser.kt\norg/archguard/scanner/analyser/sca/gradle/GradleParser\n*L\n136#1:211,9\n136#1:220\n136#1:222\n136#1:223\n190#1:224\n190#1:225,3\n136#1:221\n*E\n"})
public final class GradleParser
extends Parser {
    @NotNull
    private Map<String, DependencyEntry> versionCatalogs = new LinkedHashMap();

    @NotNull
    public final Map<String, DependencyEntry> getVersionCatalogs() {
        return this.versionCatalogs;
    }

    public final void setVersionCatalogs(@NotNull Map<String, DependencyEntry> map) {
        Intrinsics.checkNotNullParameter(map, (String)"<set-?>");
        this.versionCatalogs = map;
    }

    @Override
    @NotNull
    public List<PackageDependencies> lookupSource(@NotNull DeclFileTree file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        List deps = new ArrayList();
        CollectionsKt.addAll((Collection)deps, (Iterable)this.parseShortForm(file.getContent()));
        CollectionsKt.addAll((Collection)deps, (Iterable)this.parseKeywordArg(file.getContent()));
        CollectionsKt.addAll((Collection)deps, (Iterable)this.parseDependencySet(file.getContent()));
        CollectionsKt.addAll((Collection)deps, (Iterable)this.parseVersionCatalog(file.getContent()));
        return CollectionsKt.listOf((Object)new PackageDependencies("", "", "gradle", deps, file.getPath(), null, 32, null));
    }

    private final List<DependencyEntry> parseVersionCatalog(String content) {
        Sequence findAll = Regex.findAll$default((Regex)GradleParserKt.access$getGRADLE_VERSION_CATALOG_REGEX$p(), (CharSequence)content, (int)0, (int)2, null);
        return SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)findAll, (Function1)parseVersionCatalog.1.INSTANCE), (Function1)((Function1)new Function1<MatchResult, DependencyEntry>(this){
            final /* synthetic */ GradleParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DependencyEntry invoke(@NotNull MatchResult it) {
                DependencyEntry dependencyEntry;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    List groups = CollectionsKt.filterNotNull((Iterable)((Iterable)it.getGroups()));
                    String matchGroup = StringsKt.replace$default((String)StringsKt.substringAfter$default((String)((MatchGroup)groups.get(2)).getValue(), (String)"libs.", null, (int)2, null), (String)".", (String)"-", (boolean)false, (int)4, null);
                    DependencyEntry dependencyEntry2 = this.this$0.getVersionCatalogs().get(matchGroup);
                    DependencyEntry dependencyEntry3 = dependencyEntry2;
                    if (dependencyEntry3 == null) {
                        dependencyEntry3 = new DependencyEntry(((MatchGroup)groups.get(2)).getValue(), "", ((MatchGroup)groups.get(2)).getValue(), "", DEP_SCOPE.Companion.from(((MatchGroup)groups.get(0)).getValue()), null, null, null, 224, null);
                    }
                    dependencyEntry = dependencyEntry3;
                }
                catch (Exception e) {
                    dependencyEntry = null;
                }
                return dependencyEntry;
            }
        })));
    }

    private final List<DependencyEntry> parseShortForm(String content) {
        List versionsDep2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)Regex.findAll$default((Regex)GradleParserKt.access$getGRADLE_SHORT_IMPL_REGEX$p(), (CharSequence)content, (int)0, (int)2, null), (Function1)parseShortForm.versionsDep.1.INSTANCE), (Function1)((Function1)new Function1<MatchResult, DependencyEntry>(this){
            final /* synthetic */ GradleParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DependencyEntry invoke(@NotNull MatchResult it) {
                DependencyEntry dependencyEntry;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    Object object;
                    Object object2;
                    MatchGroupCollection groups = it.getGroups();
                    Object object3 = groups.get(1);
                    if (object3 == null || (object3 = object3.getValue()) == null) {
                        object3 = "";
                    }
                    DEP_SCOPE scope = GradleParser.access$scopeForGradle(this.this$0, (String)object3);
                    MatchGroup matchGroup = groups.get(3);
                    StringBuilder stringBuilder = new StringBuilder().append(matchGroup != null ? matchGroup.getValue() : null).append(':');
                    Object object4 = groups.get(4);
                    if (object4 == null || (object4 = object4.getValue()) == null) {
                        object4 = "";
                    }
                    String string = stringBuilder.append((String)object4).toString();
                    Object object5 = groups.get(3);
                    if (object5 == null || (object5 = object5.getValue()) == null) {
                        object5 = "";
                    }
                    if ((object2 = groups.get(4)) == null || (object2 = object2.getValue()) == null) {
                        object2 = "";
                    }
                    if ((object = groups.get(5)) == null || (object = object.getValue()) == null) {
                        object = "";
                    }
                    dependencyEntry = new DependencyEntry(string, (String)object5, (String)object2, (String)object, scope, null, null, null, 224, null);
                }
                catch (Exception e) {
                    dependencyEntry = null;
                }
                return dependencyEntry;
            }
        })));
        List noVersionDeps2 = SequencesKt.toList((Sequence)SequencesKt.mapNotNull((Sequence)SequencesKt.filter((Sequence)Regex.findAll$default((Regex)GradleParserKt.access$getSHORT_IMPL_REGEX_NO_VERSION$p(), (CharSequence)content, (int)0, (int)2, null), (Function1)parseShortForm.noVersionDeps.1.INSTANCE), (Function1)((Function1)new Function1<MatchResult, DependencyEntry>(this){
            final /* synthetic */ GradleParser this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final DependencyEntry invoke(@NotNull MatchResult it) {
                DependencyEntry dependencyEntry;
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                try {
                    Object object;
                    MatchGroupCollection groups = it.getGroups();
                    Object object2 = groups.get(1);
                    if (object2 == null || (object2 = object2.getValue()) == null) {
                        object2 = "";
                    }
                    DEP_SCOPE scope = GradleParser.access$scopeForGradle(this.this$0, (String)object2);
                    MatchGroup matchGroup = groups.get(3);
                    MatchGroup matchGroup2 = groups.get(4);
                    String string = (matchGroup != null ? matchGroup.getValue() : null) + ':' + (matchGroup2 != null ? matchGroup2.getValue() : null);
                    Object object3 = groups.get(3);
                    if (object3 == null || (object3 = object3.getValue()) == null) {
                        object3 = "";
                    }
                    if ((object = groups.get(4)) == null || (object = object.getValue()) == null) {
                        object = "";
                    }
                    dependencyEntry = new DependencyEntry(string, (String)object3, (String)object, "", scope, null, null, null, 224, null);
                }
                catch (Exception e) {
                    dependencyEntry = null;
                }
                return dependencyEntry;
            }
        })));
        return CollectionsKt.plus((Collection)versionsDep2, (Iterable)noVersionDeps2);
    }

    private final DEP_SCOPE scopeForGradle(String text) {
        if (StringsKt.startsWith$default((String)text, (String)"test", (boolean)false, (int)2, null)) {
            return DEP_SCOPE.TEST;
        }
        if (StringsKt.startsWith$default((String)text, (String)"runtime", (boolean)false, (int)2, null)) {
            return DEP_SCOPE.RUNTIME;
        }
        return DEP_SCOPE.NORMAL;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DependencyEntry> parseKeywordArg(String content) {
        void $this$mapNotNullTo$iv$iv;
        Iterable $this$mapNotNull$iv = StringsKt.lines((CharSequence)content);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DependencyEntry dependencyEntry;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String line = (String)element$iv$iv;
            boolean bl2 = false;
            MatchResult matchResult = Regex.find$default((Regex)GradleParserKt.access$getGRADLE_KEYWORD_REGEX$p(), (CharSequence)line, (int)0, (int)2, null);
            if (matchResult != null && matchResult.getGroups().size() > 6) {
                MatchGroup matchGroup = matchResult.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                DEP_SCOPE scope = this.scopeForGradle(matchGroup.getValue());
                String group = this.valueFromRegex("group", line);
                String artifact = this.valueFromRegex("name", line);
                String version = this.valueFromRegex("version", line);
                dependencyEntry = new DependencyEntry(group + ':' + artifact, group, artifact, version, scope, null, null, null, 224, null);
            } else {
                dependencyEntry = null;
            }
            if (dependencyEntry == null) continue;
            DependencyEntry it$iv$iv = dependencyEntry;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    private final String valueFromRegex(String key, String text) {
        Regex keyRegex = new Regex('(' + key + "(\\s*=|:)\\s*['\"]([^'\"]+)['\"])");
        MatchResult matchResult = Regex.find$default((Regex)keyRegex, (CharSequence)text, (int)0, (int)2, null);
        if (matchResult != null) {
            MatchGroup matchGroup = matchResult.getGroups().get(3);
            Intrinsics.checkNotNull((Object)matchGroup);
            return matchGroup.getValue();
        }
        return "";
    }

    /*
     * WARNING - void declaration
     */
    private final List<DependencyEntry> parseDependencySet(String content) {
        List deps = new ArrayList();
        Iterator sequence = StringsKt.lineSequence((CharSequence)content).iterator();
        while (sequence.hasNext()) {
            void $this$mapTo$iv$iv;
            String next;
            String text = (String)sequence.next();
            MatchResult depSetResult = Regex.find$default((Regex)GradleParserKt.access$getDEPENDENCY_SET_START_REGEX$p(), (CharSequence)text, (int)0, (int)2, null);
            if (depSetResult == null || depSetResult.getGroups().size() != 2) continue;
            List entries = new ArrayList();
            MatchGroup matchGroup = depSetResult.getGroups().get(1);
            Intrinsics.checkNotNull((Object)matchGroup);
            String entry = matchGroup.getValue();
            String group = this.valueFromRegex("group", entry);
            String version = this.valueFromRegex("version", entry);
            while (sequence.hasNext() && !StringsKt.contains$default((CharSequence)(next = (String)sequence.next()), (CharSequence)"}", (boolean)false, (int)2, null)) {
                ((Collection)entries).add(next);
            }
            Iterable $this$map$iv = entries;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                MatchResult find = Regex.find$default((Regex)GradleParserKt.access$getENTRY_REGEX$p(), (CharSequence)((CharSequence)it), (int)0, (int)2, null);
                if (find != null && find.getGroups().size() == 2) {
                    MatchGroup matchGroup2 = find.getGroups().get(1);
                    Intrinsics.checkNotNull((Object)matchGroup2);
                    String artifact = matchGroup2.getValue();
                    Collection collection2 = deps;
                    String string2 = group + ':' + artifact;
                    collection2.add(new DependencyEntry(string2, group, artifact, version, null, null, null, null, 240, null));
                }
                collection.add(Unit.INSTANCE);
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
        }
        return deps;
    }

    public static final /* synthetic */ DEP_SCOPE access$scopeForGradle(GradleParser $this, String text) {
        return $this.scopeForGradle(text);
    }
}

