/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.sca.gradle;

import chapi.domain.core.CodeContainer;
import chapi.domain.core.CodeField;
import chapi.parser.toml.TomlAnalyser;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import org.archguard.scanner.analyser.sca.gradle.GradleTomlParser;
import org.archguard.scanner.core.sca.DependencyEntry;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J6\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012H\u0002J\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u0012J0\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u00122\u0006\u0010\u0015\u001a\u00020\u00162\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0012H\u0002R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/archguard/scanner/analyser/sca/gradle/GradleTomlParser;", "", "content", "", "(Ljava/lang/String;)V", "analyser", "Lchapi/parser/toml/TomlAnalyser;", "getAnalyser", "()Lchapi/parser/toml/TomlAnalyser;", "logger", "Lmu/KLogger;", "dependenciesForDeclarations", "", "Lorg/archguard/scanner/core/sca/DependencyEntry;", "declarations", "", "Lchapi/domain/core/CodeField;", "versions", "", "parse", "versionCatalogLibraryDependencies", "tomlFile", "Lchapi/domain/core/CodeContainer;", "analyser_sca"})
@SourceDebugExtension(value={"SMAP\nGradleTomlParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GradleTomlParser.kt\norg/archguard/scanner/analyser/sca/gradle/GradleTomlParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,123:1\n766#2:124\n857#2,2:125\n1549#2:127\n1620#2,2:128\n1855#2,2:130\n1622#2:132\n766#2:133\n857#2,2:134\n1855#2,2:136\n1179#2,2:138\n1253#2,2:140\n1855#2,2:142\n1256#2:144\n*S KotlinDebug\n*F\n+ 1 GradleTomlParser.kt\norg/archguard/scanner/analyser/sca/gradle/GradleTomlParser\n*L\n44#1:124\n44#1:125,2\n44#1:127\n44#1:128,2\n45#1:130,2\n44#1:132\n63#1:133\n63#1:134,2\n64#1:136,2\n73#1:138,2\n73#1:140,2\n75#1:142,2\n73#1:144\n*E\n"})
public final class GradleTomlParser {
    @NotNull
    private final String content;
    @NotNull
    private final KLogger logger;
    @NotNull
    private final TomlAnalyser analyser;

    public GradleTomlParser(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.content = content;
        this.logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);
        this.analyser = new TomlAnalyser();
    }

    @NotNull
    public final TomlAnalyser getAnalyser() {
        return this.analyser;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Map<String, DependencyEntry> parse() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        CodeContainer it;
        void $this$filterTo$iv$iv;
        CodeContainer containers;
        Map entries = new LinkedHashMap();
        try {
            containers = this.analyser.analysis(this.content, "libs.versions.toml");
        }
        catch (Exception e) {
            return entries;
        }
        CodeContainer tomlFile = containers;
        Map versions = new LinkedHashMap();
        Iterable $this$filter$iv = tomlFile.getContainers();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (CodeContainer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPackageName(), (Object)"versions")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void container;
            it = (CodeContainer)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Iterable $this$forEach$iv = container.getFields();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                CodeField it2 = (CodeField)element$iv;
                boolean bl2 = false;
                versions.put(it2.getTypeKey(), it2.getTypeValue());
            }
            collection.add(Unit.INSTANCE);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        entries.putAll(this.versionCatalogLibraryDependencies(tomlFile, versions));
        return entries;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DependencyEntry> versionCatalogLibraryDependencies(CodeContainer tomlFile, Map<String, String> versions) {
        void $this$forEach$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Map entries = new LinkedHashMap();
        Iterable iterable = tomlFile.getContainers();
        boolean $i$f$filter = false;
        Iterator iterator = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            CodeContainer it = (CodeContainer)element$iv$iv;
            boolean bl = false;
            if (!Intrinsics.areEqual((Object)it.getPackageName(), (Object)"libraries")) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeContainer it = (CodeContainer)element$iv;
            boolean bl = false;
            entries.putAll(this.dependenciesForDeclarations(it.getFields(), versions));
        }
        return entries;
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, DependencyEntry> dependenciesForDeclarations(List<CodeField> declarations, Map<String, String> versions) {
        void $this$associateTo$iv$iv;
        Iterable $this$associate$iv = declarations;
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            Map map = destination$iv$iv;
            CodeField declaration = (CodeField)element$iv$iv;
            boolean bl = false;
            DependencyEntry entry = new DependencyEntry("", null, null, null, null, null, null, declaration.getTypeKey(), 126, null);
            Iterable $this$forEach$iv = declaration.getArrayValue();
            boolean $i$f$forEach = false;
            String[] stringArray = $this$forEach$iv.iterator();
            while (stringArray.hasNext()) {
                Object element$iv = stringArray.next();
                CodeField it = (CodeField)element$iv;
                boolean bl2 = false;
                String value = it.getTypeValue();
                switch (it.getTypeKey()) {
                    case "version": {
                        List children = it.getArrayValue();
                        if (!((Collection)children).isEmpty() && Intrinsics.areEqual((Object)((CodeField)children.get(0)).getTypeKey(), (Object)"ref")) {
                            String string = ((CodeField)children.get(0)).getTypeValue();
                            if (string == null) {
                                string = "";
                            }
                            entry.setVersion(string);
                            break;
                        }
                        entry.setVersion(value);
                        break;
                    }
                    case "version.ref": {
                        String string = versions.get(value);
                        if (string == null) {
                            string = "";
                        }
                        entry.setVersion(string);
                        break;
                    }
                    case "group": {
                        entry.setGroup(value);
                        break;
                    }
                    case "name": {
                        entry.setArtifact(value);
                        break;
                    }
                    case "module": {
                        String[] stringArray2 = new String[]{":"};
                        List parts = StringsKt.split$default((CharSequence)value, (String[])stringArray2, (boolean)false, (int)0, (int)6, null);
                        String string = (String)CollectionsKt.getOrNull((List)parts, (int)0);
                        if (string == null) {
                            string = "";
                        }
                        entry.setGroup(string);
                        String string2 = (String)CollectionsKt.getOrNull((List)parts, (int)1);
                        if (string2 == null) {
                            string2 = "";
                        }
                        entry.setArtifact(string2);
                        break;
                    }
                    default: {
                        this.logger.warn("Unknown node type: " + it.getClass());
                    }
                }
            }
            if (Intrinsics.areEqual((Object)declaration.getTypeType(), (Object)"String")) {
                String module = declaration.getTypeValue();
                List parts = StringsKt.split$default((CharSequence)module, (String[])(stringArray = new String[]{":"}), (boolean)false, (int)0, (int)6, null);
                String string = (String)CollectionsKt.getOrNull((List)parts, (int)0);
                if (string == null) {
                    string = "";
                }
                entry.setGroup(string);
                String string3 = (String)CollectionsKt.getOrNull((List)parts, (int)1);
                if (string3 == null) {
                    string3 = "";
                }
                entry.setArtifact(string3);
                String string4 = (String)CollectionsKt.getOrNull((List)parts, (int)2);
                if (string4 == null) {
                    string4 = "";
                }
                entry.setVersion(string4);
            }
            entry.setName(entry.getGroup() + ':' + entry.getArtifact());
            Pair pair = TuplesKt.to((Object)entry.getAliasName(), (Object)entry);
            map.put(pair.getFirst(), pair.getSecond());
        }
        return destination$iv$iv;
    }
}

