/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.frontend;

import chapi.domain.core.CodeCall;
import chapi.domain.core.CodeDataStruct;
import chapi.domain.core.CodeField;
import chapi.domain.core.CodeFunction;
import chapi.domain.core.CodeImport;
import chapi.domain.core.CodeProperty;
import chapi.domain.core.DataStructType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.archguard.scanner.analyser.frontend.ApiCodeCall;
import org.archguard.scanner.analyser.frontend.NamingKt;
import org.archguard.scanner.analyser.frontend.identify.AxiosHttpIdentify;
import org.archguard.scanner.analyser.frontend.identify.UmiHttpIdentify;
import org.archguard.scanner.analyser.frontend.path.EcmaImportPathKt;
import org.archguard.scanner.core.sourcecode.ContainerDemand;
import org.archguard.scanner.core.sourcecode.ContainerService;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u008e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u00017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\tJ'\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00160\u001c2\u0006\u0010\u0017\u001a\u00020\t\u00a2\u0006\u0002\u0010\u001dJ\u001e\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\t2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\t0\u0019H\u0002J,\u0010\"\u001a\b\u0012\u0004\u0012\u00020\t0\r2\u0006\u0010\u0017\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u00192\u0006\u0010%\u001a\u00020\tH\u0002J&\u0010&\u001a\u00020\u00142\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\t2\f\u0010*\u001a\b\u0012\u0004\u0012\u00020\t0\rH\u0002J \u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\t2\u0006\u0010-\u001a\u00020\u001a2\u0006\u0010.\u001a\u00020/H\u0002J6\u00100\u001a\u00020\u00142\u0006\u00101\u001a\u0002022\u0006\u00103\u001a\u00020\t2\u0006\u00104\u001a\u0002052\u0006\u0010)\u001a\u00020\t2\f\u0010#\u001a\b\u0012\u0004\u0012\u00020$0\u0019H\u0002J\f\u00106\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0007\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\f\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\bj\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R6\u0010\u000e\u001a*\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r0\bj\u0014\u0012\u0004\u0012\u00020\t\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\r`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R*\u0010\u000f\u001a\u001e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u00100\bj\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\u0010`\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/archguard/scanner/analyser/frontend/FrontendApiAnalyser;", "", "()V", "DEFAULT_LOOP_API_CALL_DEPTH", "", "axiosIdent", "Lorg/archguard/scanner/analyser/frontend/identify/AxiosHttpIdentify;", "callMap", "Ljava/util/HashMap;", "", "Lchapi/domain/core/CodeCall;", "Lkotlin/collections/HashMap;", "componentCallMap", "", "componentInbounds", "httpAdapterMap", "Lorg/archguard/scanner/analyser/frontend/ApiCodeCall;", "umiIdent", "Lorg/archguard/scanner/analyser/frontend/identify/UmiHttpIdentify;", "analysisByNode", "", "node", "Lchapi/domain/core/CodeDataStruct;", "workspace", "analysisByPath", "", "Lorg/archguard/scanner/core/sourcecode/ContainerService;", "nodes", "", "([Lchapi/domain/core/CodeDataStruct;Ljava/lang/String;)Ljava/util/List;", "createHttpApi", "Lorg/archguard/scanner/core/sourcecode/ContainerDemand;", "name", "routes", "createInbounds", "imports", "Lchapi/domain/core/CodeImport;", "filePath", "fieldToCallMap", "field", "Lchapi/domain/core/CodeField;", "componentName", "inbounds", "lookupSource", "methodName", "componentRef", "loopDepth", "Lorg/archguard/scanner/analyser/frontend/FrontendApiAnalyser$LoopDepth;", "recursiveCall", "func", "Lchapi/domain/core/CodeFunction;", "calleeName", "isComponent", "", "toContainerServices", "LoopDepth", "feat_apicalls"})
@SourceDebugExtension(value={"SMAP\nFrontendApiAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FrontendApiAnalyser.kt\norg/archguard/scanner/analyser/frontend/FrontendApiAnalyser\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,239:1\n13579#2,2:240\n1855#3,2:242\n1855#3:244\n1855#3,2:245\n1856#3:247\n1855#3,2:249\n1855#3:252\n1855#3:253\n1855#3,2:254\n1856#3:256\n1856#3:257\n1855#3:258\n1855#3,2:259\n1856#3:261\n1855#3:262\n1855#3,2:263\n1855#3,2:265\n1856#3:267\n215#4:248\n216#4:251\n*S KotlinDebug\n*F\n+ 1 FrontendApiAnalyser.kt\norg/archguard/scanner/analyser/frontend/FrontendApiAnalyser\n*L\n52#1:240,2\n69#1:242,2\n74#1:244\n85#1:245,2\n74#1:247\n114#1:249,2\n177#1:252\n181#1:253\n182#1:254,2\n181#1:256\n177#1:257\n195#1:258\n196#1:259,2\n195#1:261\n212#1:262\n214#1:263,2\n233#1:265,2\n212#1:267\n112#1:248\n112#1:251\n*E\n"})
public final class FrontendApiAnalyser {
    @NotNull
    private HashMap<String, List<String>> componentCallMap = new HashMap();
    @NotNull
    private HashMap<String, List<String>> componentInbounds = new HashMap();
    @NotNull
    private HashMap<String, CodeCall> callMap = new HashMap();
    @NotNull
    private HashMap<String, ApiCodeCall> httpAdapterMap = new HashMap();
    @NotNull
    private final AxiosHttpIdentify axiosIdent = new AxiosHttpIdentify();
    @NotNull
    private final UmiHttpIdentify umiIdent = new UmiHttpIdentify();
    private final int DEFAULT_LOOP_API_CALL_DEPTH;

    public FrontendApiAnalyser() {
        this.DEFAULT_LOOP_API_CALL_DEPTH = 3;
    }

    @NotNull
    public final List<ContainerService> analysisByPath(@NotNull CodeDataStruct[] nodes, @NotNull String workspace) {
        Intrinsics.checkNotNullParameter((Object)nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        CodeDataStruct[] $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            CodeDataStruct element$iv;
            CodeDataStruct node = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            this.analysisByNode(node, workspace);
        }
        return this.toContainerServices();
    }

    public final void analysisByNode(@NotNull CodeDataStruct node, @NotNull String workspace) {
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)workspace, (String)"workspace");
        boolean isComponent = false;
        boolean isComponentExt = Intrinsics.areEqual((Object)node.fileExt(), (Object)"tsx") || Intrinsics.areEqual((Object)node.fileExt(), (Object)"jsx");
        boolean isNotInterface = node.getType() != DataStructType.INTERFACE;
        List<String> inbounds = this.createInbounds(workspace, node.getImports(), node.getFilePath());
        String moduleName = StringsKt.substringBeforeLast((String)EcmaImportPathKt.relativeRoot(workspace, node.getFilePath()), (char)'.', (String)"");
        String componentName = NamingKt.naming(moduleName, node.getNodeName());
        Iterable $this$forEach$iv = node.getFields();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeField field = (CodeField)element$iv;
            boolean bl = false;
            this.fieldToCallMap(field, componentName, inbounds);
        }
        $this$forEach$iv = node.getFunctions();
        $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeFunction func = (CodeFunction)element$iv;
            boolean bl = false;
            boolean bl2 = isComponent = isNotInterface && isComponentExt && func.getIsReturnHtml();
            if (isComponent) {
                ((Map)this.componentCallMap).put(componentName, (List)new ArrayList());
            }
            String calleeName = null;
            calleeName = NamingKt.naming(componentName, func.getName());
            if (isComponent) {
                calleeName = componentName;
            }
            Iterable $this$forEach$iv2 = func.getFunctionCalls();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                List<String> list;
                CodeCall call = (CodeCall)element$iv2;
                boolean bl3 = false;
                ((Map)this.callMap).put(calleeName, call);
                if (this.axiosIdent.isMatch(call, node.getImports())) {
                    ((Map)this.httpAdapterMap).put(calleeName, ApiCodeCall.Companion.from(call, "axios"));
                }
                if (this.umiIdent.isMatch(call, node.getImports())) {
                    ((Map)this.httpAdapterMap).put(calleeName, ApiCodeCall.Companion.from(call, "umi"));
                }
                if (!isComponent) continue;
                List<String> list2 = list = this.componentCallMap.get(componentName);
                if (list2 == null) continue;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"componentCallMap[componentName]");
                ((Collection)list).add(call.getFunctionName());
            }
            this.recursiveCall(func, calleeName, isComponent, componentName, node.getImports());
            if (!isComponent) continue;
            ((Map)this.componentInbounds).put(componentName, inbounds);
        }
    }

    @NotNull
    public final List<ContainerService> toContainerServices() {
        List componentCalls = new ArrayList();
        Map $this$forEach$iv = this.componentInbounds;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry inbound = element$iv = iterator.next();
            boolean bl = false;
            ContainerService componentRef = new ContainerService((String)inbound.getKey(), null, null, 6, null);
            Iterable $this$forEach$iv2 = (Iterable)inbound.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                if (this.httpAdapterMap.get(it) != null) {
                    List routes = CollectionsKt.listOf((Object)it);
                    componentRef.setDemands(CollectionsKt.plus((Collection)componentRef.getDemands(), (Object)this.createHttpApi(it, routes)));
                    continue;
                }
                this.lookupSource(it, componentRef, new LoopDepth(1));
            }
            if (!(!((Collection)componentRef.getDemands()).isEmpty())) continue;
            ((Collection)componentCalls).add(componentRef);
        }
        return componentCalls;
    }

    private final void lookupSource(String methodName, ContainerService componentRef, LoopDepth loopDepth) {
        if (loopDepth.getIndex() > this.DEFAULT_LOOP_API_CALL_DEPTH) {
            return;
        }
        int n = loopDepth.getIndex();
        loopDepth.setIndex(n + 1);
        if (this.callMap.get(methodName) != null) {
            CodeCall codeCall = this.callMap.get(methodName);
            Intrinsics.checkNotNull((Object)codeCall);
            CodeCall codeCall2 = codeCall;
            String name = NamingKt.naming(codeCall2.getNodeName(), codeCall2.getFunctionName());
            if (this.httpAdapterMap.get(name) != null) {
                Object[] objectArray = new String[]{methodName, name};
                List routes = CollectionsKt.listOf((Object[])objectArray);
                componentRef.setDemands(CollectionsKt.plus((Collection)componentRef.getDemands(), (Object)this.createHttpApi(name, routes)));
            } else {
                this.lookupSource(name, componentRef, loopDepth);
            }
        }
    }

    private final ContainerDemand createHttpApi(String name, List<String> routes) {
        ApiCodeCall apiCodeCall = this.httpAdapterMap.get(name);
        Intrinsics.checkNotNull((Object)apiCodeCall);
        ApiCodeCall call = apiCodeCall;
        ContainerDemand httpApi = new ContainerDemand(null, null, null, null, null, null, 63, null);
        String string = call.getApiType();
        if (Intrinsics.areEqual((Object)string, (Object)"axios")) {
            httpApi = this.axiosIdent.convert(call);
        } else if (Intrinsics.areEqual((Object)string, (Object)"umi")) {
            httpApi = this.umiIdent.convert(call);
        }
        httpApi.setSource_caller(name);
        httpApi.setCall_routes(routes);
        return httpApi;
    }

    private final void fieldToCallMap(CodeField field, String componentName, List<String> inbounds) {
        Iterable $this$forEach$iv = field.getCalls();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeCall it = (CodeCall)element$iv;
            boolean bl = false;
            String calleeName = NamingKt.naming(componentName, field.getTypeKey());
            ((Map)this.callMap).put(calleeName, it);
            Iterable $this$forEach$iv2 = it.getParameters();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                CodeProperty it2 = (CodeProperty)element$iv2;
                boolean bl2 = false;
                Iterable $this$forEach$iv3 = inbounds;
                boolean $i$f$forEach3 = false;
                for (Object element$iv3 : $this$forEach$iv3) {
                    String inbound = (String)element$iv3;
                    boolean bl3 = false;
                    if (!StringsKt.endsWith$default((String)inbound, (String)("::" + it2.getTypeValue()), (boolean)false, (int)2, null)) continue;
                    Object object = new String[]{"::"};
                    List split = StringsKt.split$default((CharSequence)inbound, (String[])object, (boolean)false, (int)0, (int)6, null);
                    object = this.callMap;
                    String string = (String)split.get(1);
                    String string2 = (String)split.get(0);
                    string = new CodeCall(null, null, string2, string, null, null, null, 115, null);
                    object.put(calleeName, string);
                }
            }
        }
    }

    private final List<String> createInbounds(String workspace, List<CodeImport> imports, String filePath) {
        List inbounds = new ArrayList();
        Iterable $this$forEach$iv = imports;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeImport imp = (CodeImport)element$iv;
            boolean bl = false;
            Iterable $this$forEach$iv2 = imp.getUsageName();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                String it = (String)element$iv2;
                boolean bl2 = false;
                String source = EcmaImportPathKt.ecmaImportConvert(workspace, filePath, imp.getSource());
                ((Collection)inbounds).add(NamingKt.naming(source, it));
            }
        }
        return inbounds;
    }

    private final void recursiveCall(CodeFunction func, String calleeName, boolean isComponent, String componentName, List<CodeImport> imports) {
        Iterable $this$forEach$iv = func.getInnerFunctions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            CodeFunction inner = (CodeFunction)element$iv;
            boolean bl = false;
            FrontendApiAnalyser $this$recursiveCall_u24lambda_u2415_u24lambda_u2413 = this;
            boolean bl2 = false;
            Iterable $this$forEach$iv2 = inner.getFunctionCalls();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                List<String> list;
                CodeCall innerCall = (CodeCall)element$iv2;
                boolean bl3 = false;
                FrontendApiAnalyser $this$recursiveCall_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411 = $this$recursiveCall_u24lambda_u2415_u24lambda_u2413;
                boolean bl4 = false;
                ((Map)$this$recursiveCall_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.callMap).put(calleeName, innerCall);
                if ($this$recursiveCall_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.umiIdent.isMatch(innerCall, imports)) {
                    ((Map)$this$recursiveCall_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.httpAdapterMap).put(calleeName, ApiCodeCall.Companion.from(innerCall, "umi"));
                }
                if ($this$recursiveCall_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.axiosIdent.isMatch(innerCall, imports)) {
                    ((Map)$this$recursiveCall_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.httpAdapterMap).put(calleeName, ApiCodeCall.Companion.from(innerCall, "axios"));
                }
                if (!isComponent) continue;
                List<String> list2 = list = $this$recursiveCall_u24lambda_u2415_u24lambda_u2413_u24lambda_u2412_u24lambda_u2411.componentCallMap.get(componentName);
                if (list2 == null) continue;
                Intrinsics.checkNotNullExpressionValue(list2, (String)"componentCallMap[componentName]");
                ((Collection)list).add(innerCall.getFunctionName());
            }
            Iterable $this$forEach$iv3 = func.getInnerFunctions();
            boolean $i$f$forEach3 = false;
            for (Object element$iv3 : $this$forEach$iv3) {
                CodeFunction it = (CodeFunction)element$iv3;
                boolean bl5 = false;
                this.recursiveCall(it, calleeName, isComponent, componentName, imports);
            }
        }
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\u0004\u00a8\u0006\b"}, d2={"Lorg/archguard/scanner/analyser/frontend/FrontendApiAnalyser$LoopDepth;", "", "index", "", "(I)V", "getIndex", "()I", "setIndex", "feat_apicalls"})
    public static final class LoopDepth {
        private int index;

        public LoopDepth(int index) {
            this.index = index;
        }

        public final int getIndex() {
            return this.index;
        }

        public final void setIndex(int n) {
            this.index = n;
        }
    }
}

