/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser.database;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchGroup;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import mu.KLogger;
import mu.KotlinLogging;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.archguard.scanner.analyser.database.MysqlIdentApp;
import org.archguard.scanner.analyser.database.SimpleDbStructure;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lorg/archguard/scanner/analyser/database/MysqlIdentApp;", "", "()V", "SELECT_FROM_SQL", "Lkotlin/text/Regex;", "UPDATE_SQL", "logger", "Lmu/KLogger;", "analysis", "Lorg/archguard/scanner/analyser/database/SimpleDbStructure;", "sql", "", "feat_datamap"})
@SourceDebugExtension(value={"SMAP\nMysqlIdentApp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MysqlIdentApp.kt\norg/archguard/scanner/analyser/database/MysqlIdentApp\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,43:1\n1549#2:44\n1620#2,3:45\n*S KotlinDebug\n*F\n+ 1 MysqlIdentApp.kt\norg/archguard/scanner/analyser/database/MysqlIdentApp\n*L\n20#1:44\n20#1:45,3\n*E\n"})
public final class MysqlIdentApp {
    @NotNull
    public static final MysqlIdentApp INSTANCE = new MysqlIdentApp();
    @NotNull
    private static final Regex UPDATE_SQL = new Regex("update\\s+([a-zA-Z_]+)");
    @NotNull
    private static final Regex SELECT_FROM_SQL = new Regex("select\\s+.*\\s+from\\s+([a-zA-Z_]+)");
    @NotNull
    private static final KLogger logger = KotlinLogging.INSTANCE.logger((Function0)logger.1.INSTANCE);

    private MysqlIdentApp() {
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final SimpleDbStructure analysis(@NotNull String sql) {
        Intrinsics.checkNotNullParameter((Object)sql, (String)"sql");
        SimpleDbStructure table = new SimpleDbStructure(null, null, 3, null);
        try {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Statement statement = CCJSqlParserUtil.parse((String)sql);
            Intrinsics.checkNotNullExpressionValue((Object)statement, (String)"parse(sql)");
            Statement statement2 = statement;
            TablesNamesFinder tablesNamesFinder = new TablesNamesFinder();
            List list = tablesNamesFinder.getTableList(statement2);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"tablesNamesFinder.getTableList(statement)");
            Iterable iterable = list;
            SimpleDbStructure simpleDbStructure = table;
            boolean $i$f$map = false;
            void var7_13 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(StringsKt.removeSurrounding((String)it, (CharSequence)"`"));
            }
            simpleDbStructure.setTableNames((List)destination$iv$iv);
        }
        catch (Exception e) {
            if (Regex.find$default((Regex)UPDATE_SQL, (CharSequence)sql, (int)0, (int)2, null) != null) {
                MatchResult matchResult = Regex.find$default((Regex)UPDATE_SQL, (CharSequence)sql, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                MatchGroup matchGroup = matchResult.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String tableName = matchGroup.getValue();
                Object[] objectArray = new String[]{tableName};
                table.setTableNames(CollectionsKt.arrayListOf((Object[])objectArray));
                return table;
            }
            if (Regex.find$default((Regex)SELECT_FROM_SQL, (CharSequence)sql, (int)0, (int)2, null) != null) {
                MatchResult matchResult = Regex.find$default((Regex)SELECT_FROM_SQL, (CharSequence)sql, (int)0, (int)2, null);
                Intrinsics.checkNotNull((Object)matchResult);
                MatchGroup matchGroup = matchResult.getGroups().get(1);
                Intrinsics.checkNotNull((Object)matchGroup);
                String tableName = matchGroup.getValue();
                Object[] objectArray = new String[]{tableName};
                table.setTableNames(CollectionsKt.arrayListOf((Object[])objectArray));
                return table;
            }
            logger.info("analysis failure for sql: " + sql);
            return null;
        }
        return table;
    }
}

