/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.scanner.analyser;

import chapi.domain.core.CodeDataStruct;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.archguard.scanner.analyser.database.JvmSqlAnalyser;
import org.archguard.scanner.analyser.xml.XmlParser;
import org.archguard.scanner.analyser.xml.mybatis.MybatisEntry;
import org.archguard.scanner.core.client.ArchGuardClient;
import org.archguard.scanner.core.diffchanges.NodeRelationBuilder;
import org.archguard.scanner.core.sourcecode.ASTSourceCodeAnalyser;
import org.archguard.scanner.core.sourcecode.CodeDatabaseRelation;
import org.archguard.scanner.core.sourcecode.SourceCodeContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u001c\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\u000eH\u0016J\b\u0010\u0012\u001a\u00020\u0013H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0016\u0010\n\u001a\n \f*\u0004\u0018\u00010\u000b0\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lorg/archguard/scanner/analyser/DataMapAnalyser;", "Lorg/archguard/scanner/core/sourcecode/ASTSourceCodeAnalyser;", "Lorg/archguard/scanner/core/diffchanges/NodeRelationBuilder;", "context", "Lorg/archguard/scanner/core/sourcecode/SourceCodeContext;", "(Lorg/archguard/scanner/core/sourcecode/SourceCodeContext;)V", "client", "Lorg/archguard/scanner/core/client/ArchGuardClient;", "getContext", "()Lorg/archguard/scanner/core/sourcecode/SourceCodeContext;", "logger", "Lorg/slf4j/Logger;", "kotlin.jvm.PlatformType", "analyse", "", "Lorg/archguard/scanner/core/sourcecode/CodeDatabaseRelation;", "input", "Lchapi/domain/core/CodeDataStruct;", "logFunctionMapInfo", "", "feat_datamap"})
@SourceDebugExtension(value={"SMAP\nDataMapAnalyser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataMapAnalyser.kt\norg/archguard/scanner/analyser/DataMapAnalyser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,78:1\n1360#2:79\n1446#2,5:80\n1549#2:85\n1620#2,3:86\n215#3,2:89\n215#3,2:91\n215#3,2:93\n*S KotlinDebug\n*F\n+ 1 DataMapAnalyser.kt\norg/archguard/scanner/analyser/DataMapAnalyser\n*L\n31#1:79\n31#1:80,5\n38#1:85\n38#1:86,3\n62#1:89,2\n68#1:91,2\n73#1:93,2\n*E\n"})
public final class DataMapAnalyser
extends NodeRelationBuilder
implements ASTSourceCodeAnalyser {
    @NotNull
    private final SourceCodeContext context;
    @NotNull
    private final ArchGuardClient client;
    private final Logger logger;

    public DataMapAnalyser(@NotNull SourceCodeContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.client = this.getContext().getClient();
        this.logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    }

    @NotNull
    public SourceCodeContext getContext() {
        return this.context;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public List<CodeDatabaseRelation> analyse(@NotNull List<CodeDataStruct> input) {
        Collection destination$iv$iv;
        List databaseRelations;
        Intrinsics.checkNotNullParameter(input, (String)"input");
        String string = this.getContext().getLanguage().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        String language = string;
        String path = this.getContext().getPath();
        String string2 = language;
        if (Intrinsics.areEqual((Object)string2, (Object)"java") ? true : Intrinsics.areEqual((Object)string2, (Object)"kotlin")) {
            void $this$mapTo$iv$iv;
            void $this$flatMapTo$iv$iv;
            StringBuilder stringBuilder = new StringBuilder().append("start analysis database api ---- ");
            String string3 = language.toLowerCase(Locale.ROOT);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
            this.logger.info(stringBuilder.append(string3).toString());
            this.fillFunctionMap(input);
            this.fillReverseCallMap(input);
            if (this.getContext().getDebug()) {
                this.logFunctionMapInfo();
            }
            JvmSqlAnalyser sqlAnalyser = new JvmSqlAnalyser();
            Iterable $this$flatMap$iv = input;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                CodeDataStruct data = (CodeDataStruct)element$iv$iv;
                boolean bl = false;
                Iterable list$iv$iv = sqlAnalyser.analysisByNode(data, "");
                CollectionsKt.addAll((Collection)destination$iv$iv2, (Iterable)list$iv$iv);
            }
            List records = (List)destination$iv$iv2;
            List<MybatisEntry> mybatisEntries = XmlParser.Companion.parseMybatis(path);
            List<CodeDatabaseRelation> dbRelations = sqlAnalyser.convertMyBatis(mybatisEntries);
            databaseRelations = CollectionsKt.plus((Collection)dbRelations, (Iterable)records);
            Iterable $this$map$iv = databaseRelations;
            boolean $i$f$map = false;
            Iterable iterable2 = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                CodeDatabaseRelation codeDatabaseRelation = (CodeDatabaseRelation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                List changeRelations = new ArrayList();
                String callee = it.getPackageName() + '.' + it.getClassName() + '.' + it.getFunctionName();
                this.resetCount();
                NodeRelationBuilder.calculateReverseCalls$default((NodeRelationBuilder)this, (String)callee, (List)changeRelations, (int)0, (int)4, null);
                it.setRelations(changeRelations);
                collection.add(it);
            }
        } else {
            throw new IllegalArgumentException("Unsupported language: " + language);
        }
        List cfr_ignored_0 = (List)destination$iv$iv;
        List relations = databaseRelations;
        this.client.saveRelation(relations);
        return relations;
    }

    private final void logFunctionMapInfo() {
        Object object;
        Object element$iv;
        File file = new File("function_map.txt");
        Map $this$forEach$iv = this.getFunctionMap();
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            object = element$iv = iterator.next();
            boolean bl = false;
            String k = (String)object.getKey();
            boolean v = (Boolean)object.getValue();
            FilesKt.appendText$default((File)file, (String)(k + ": " + v + '\n'), null, (int)2, null);
        }
        File file2 = new File("reverse_call_map.txt");
        Map $this$forEach$iv2 = this.getReverseCallMap();
        boolean $i$f$forEach2 = false;
        element$iv = $this$forEach$iv2.entrySet().iterator();
        while (element$iv.hasNext()) {
            Map.Entry element$iv2;
            Map.Entry bl = element$iv2 = (Map.Entry)element$iv.next();
            boolean bl2 = false;
            String k = (String)bl.getKey();
            List v = (List)bl.getValue();
            FilesKt.appendText$default((File)file2, (String)(k + ": " + v + '\n'), null, (int)2, null);
        }
        File file3 = new File("injection_map.txt");
        Map $this$forEach$iv3 = this.getInjectionMap();
        boolean $i$f$forEach3 = false;
        object = $this$forEach$iv3.entrySet().iterator();
        while (object.hasNext()) {
            Map.Entry element$iv3;
            Map.Entry entry = element$iv3 = (Map.Entry)object.next();
            boolean bl = false;
            String k = (String)entry.getKey();
            String v = (String)entry.getValue();
            FilesKt.appendText$default((File)file3, (String)(k + ": " + v + '\n'), null, (int)2, null);
        }
    }

    @Nullable
    public List<Object> analyse(@Nullable Object input) {
        return ASTSourceCodeAnalyser.DefaultImpls.analyse((ASTSourceCodeAnalyser)this, (Object)input);
    }
}

