/*
 * Decompiled with CFR 0.152.
 */
package org.archguard.linter.rule.comment.rules;

import chapi.domain.core.CodeFunction;
import chapi.domain.core.CodeProperty;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import org.archguard.linter.rule.comment.CommentRule;
import org.archguard.linter.rule.comment.model.CodeComment;
import org.archguard.linter.rule.comment.rules.MissingParameterDescRule;
import org.archguard.rule.core.IssuePosition;
import org.archguard.rule.core.Rule;
import org.archguard.rule.core.Severity;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J`\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2:\u0010\u000e\u001a6\u0012\u0013\u0012\u00110\u0010\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0013\u0012\u0013\u0012\u00110\u0014\u00a2\u0006\f\b\u0011\u0012\b\b\u0012\u0012\u0004\b\b(\u0015\u0012\u0004\u0012\u00020\u00060\u000fj\u0002`\u0016H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lorg/archguard/linter/rule/comment/rules/MissingParameterDescRule;", "Lorg/archguard/linter/rule/comment/CommentRule;", "()V", "pattern", "Lkotlin/text/Regex;", "visitFunction", "", "node", "Lchapi/domain/core/CodeFunction;", "comment", "Lorg/archguard/linter/rule/comment/model/CodeComment;", "context", "", "Lorg/archguard/rule/core/RuleContext;", "callback", "Lkotlin/Function2;", "Lorg/archguard/rule/core/Rule;", "Lkotlin/ParameterName;", "name", "rule", "Lorg/archguard/rule/core/IssuePosition;", "position", "Lorg/archguard/rule/core/IssueEmit;", "rule-comment"})
@SourceDebugExtension(value={"SMAP\nMissingParameterDescRule.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingParameterDescRule.kt\norg/archguard/linter/rule/comment/rules/MissingParameterDescRule\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,58:1\n1549#2:59\n1620#2,3:60\n*S KotlinDebug\n*F\n+ 1 MissingParameterDescRule.kt\norg/archguard/linter/rule/comment/rules/MissingParameterDescRule\n*L\n51#1:59\n51#1:60,3\n*E\n"})
public final class MissingParameterDescRule
extends CommentRule {
    @NotNull
    private final Regex pattern;

    public MissingParameterDescRule() {
        this.setId("missing-parameter-desc");
        this.setName("MissingParameterDesc");
        String string = ((Object)((Object)this)).getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this.javaClass.name");
        this.setKey(string);
        this.setDescription("The documentation is un-complete, parameter description is missing");
        this.setSeverity(Severity.WARN);
        this.pattern = new Regex("@param\\s+(\\w+)\\s+([^@]+)");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitFunction(@NotNull CodeFunction node, @NotNull CodeComment comment, @NotNull Object context, @NotNull Function2<? super Rule, ? super IssuePosition, Unit> callback) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        Sequence matches = Regex.findAll$default((Regex)this.pattern, (CharSequence)comment.getContent(), (int)0, (int)2, null);
        int nodeSize = node.getParameters().size();
        if (SequencesKt.count((Sequence)matches) != nodeSize) {
            this.setDescription("The documentation is un-complete, parameter description is missing");
            callback.invoke((Object)this, (Object)new IssuePosition(0, 0, 0, 0, null, 31, null));
            return;
        }
        Set matchNames2 = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)matches, (Function1)visitFunction.matchNames.1.INSTANCE));
        Iterable $this$map$iv = node.getParameters();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            CodeProperty codeProperty = (CodeProperty)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTypeValue());
        }
        Set nodeNames = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (!Intrinsics.areEqual((Object)matchNames2, (Object)nodeNames)) {
            this.setDescription("The documentation is error, parameter name is not match");
            callback.invoke((Object)this, (Object)new IssuePosition(0, 0, 0, 0, null, 31, null));
        }
    }
}

