/*
 * Decompiled with CFR 0.152.
 */
package org.archive.bdb;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.je.CheckpointConfig;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.DatabaseNotFoundException;
import com.sleepycat.je.Environment;
import com.sleepycat.je.EnvironmentConfig;
import com.sleepycat.je.util.DbBackup;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.filefilter.FileFilterUtils;
import org.apache.commons.io.filefilter.IOFileFilter;
import org.archive.bdb.DisposableStoredSortedMap;
import org.archive.bdb.StoredQueue;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.spring.ConfigPath;
import org.archive.util.FileUtils;
import org.archive.util.IdentityCacheable;
import org.archive.util.ObjectIdentityBdbManualCache;
import org.archive.util.ObjectIdentityCache;
import org.archive.util.TextUtils;
import org.archive.util.bdbje.EnhancedEnvironment;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.Lifecycle;

public class BdbModule
implements Lifecycle,
Checkpointable,
Closeable,
DisposableBean {
    private static final Logger LOGGER = Logger.getLogger(BdbModule.class.getName());
    protected ConfigPath dir = new ConfigPath("bdbmodule subdirectory", "state");
    protected int cachePercent = -1;
    protected int cacheSize = -1;
    protected boolean useSharedCache = true;
    protected long maxLogFileSize = 10000000L;
    protected int expectedConcurrency = 64;
    protected int jeCleanerThreads = -1;
    protected int evictorCoreThreads = -1;
    protected int evictorMaxThreads = -1;
    protected boolean useHardLinkCheckpoints = true;
    private transient EnhancedEnvironment bdbEnvironment;
    private transient StoredClassCatalog classCatalog;
    private Map<String, ObjectIdentityCache> oiCaches = new ConcurrentHashMap<String, ObjectIdentityCache>();
    private Map<String, DatabasePlusConfig> databases = new ConcurrentHashMap<String, DatabasePlusConfig>();
    protected boolean isRunning = false;
    protected Checkpoint recoveryCheckpoint;
    protected long sn = 0L;

    public ConfigPath getDir() {
        return this.dir;
    }

    public void setDir(ConfigPath dir) {
        this.dir = dir;
    }

    public int getCachePercent() {
        return this.cachePercent;
    }

    public void setCachePercent(int cachePercent) {
        this.cachePercent = cachePercent;
    }

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public boolean getUseSharedCache() {
        return this.useSharedCache;
    }

    public void setUseSharedCache(boolean useSharedCache) {
        this.useSharedCache = useSharedCache;
    }

    public long getMaxLogFileSize() {
        return this.maxLogFileSize;
    }

    public void setMaxLogFileSize(long maxLogFileSize) {
        this.maxLogFileSize = maxLogFileSize;
    }

    public int getExpectedConcurrency() {
        return this.expectedConcurrency;
    }

    public void setExpectedConcurrency(int expectedConcurrency) {
        this.expectedConcurrency = expectedConcurrency;
    }

    public int getCleanerThreads() {
        return this.jeCleanerThreads;
    }

    public void setCleanerThreads(int jeCleanerThreads) {
        this.jeCleanerThreads = jeCleanerThreads;
    }

    public int getEvictorCoreThreads() {
        return this.evictorCoreThreads;
    }

    public void setEvictorCoreThreads(int evictorCoreThreads) {
        this.evictorCoreThreads = evictorCoreThreads;
    }

    public int getEvictorMaxThreads() {
        return this.evictorMaxThreads;
    }

    public void setEvictorMaxThreads(int evictorMaxThreads) {
        this.evictorMaxThreads = evictorMaxThreads;
    }

    public boolean getUseHardLinkCheckpoints() {
        return this.useHardLinkCheckpoints;
    }

    public void setUseHardLinkCheckpoints(boolean useHardLinkCheckpoints) {
        this.useHardLinkCheckpoints = useHardLinkCheckpoints;
    }

    public synchronized void start() {
        if (this.isRunning()) {
            return;
        }
        this.isRunning = true;
        try {
            boolean isRecovery = false;
            if (this.recoveryCheckpoint != null) {
                isRecovery = true;
                this.doRecover();
            }
            this.setup(this.getDir().getFile(), !isRecovery);
        }
        catch (DatabaseException e) {
            throw new IllegalStateException(e);
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
    }

    protected void setup(File f, boolean create) throws DatabaseException, IOException {
        int maxEvictors;
        int evictors;
        EnvironmentConfig config = new EnvironmentConfig();
        config.setAllowCreate(create);
        config.setLockTimeout(75L, TimeUnit.MINUTES);
        if (this.getCacheSize() > 0) {
            config.setCacheSize((long)this.getCacheSize());
            if (this.getCachePercent() > 0) {
                LOGGER.warning("cachePercent and cacheSize are both set. Only cacheSize will be used.");
            }
        } else if (this.getCachePercent() > 0) {
            config.setCachePercent(this.getCachePercent());
        }
        config.setSharedCache(this.getUseSharedCache());
        long nLockTables = this.getExpectedConcurrency() - 1;
        while (!BigInteger.valueOf(nLockTables).isProbablePrime(Integer.MAX_VALUE)) {
            --nLockTables;
        }
        config.setConfigParam("je.lock.nLockTables", Long.toString(nLockTables));
        int cleaners = this.getCleanerThreads();
        if (cleaners > 0) {
            config.setConfigParam("je.cleaner.threads", Integer.toString(cleaners));
        }
        if ((evictors = this.getEvictorCoreThreads()) > -1) {
            config.setConfigParam("je.evictor.coreThreads", Integer.toString(evictors));
        }
        if ((maxEvictors = this.getEvictorMaxThreads()) > 0) {
            config.setConfigParam("je.evictor.maxThreads", Integer.toString(maxEvictors));
        }
        config.setConfigParam("je.log.faultReadSize", "6144");
        config.setConfigParam("je.log.fileMax", Long.toString(this.getMaxLogFileSize()));
        if (!this.getUseHardLinkCheckpoints()) {
            config.setConfigParam("je.cleaner.expunge", "false");
        }
        FileUtils.ensureWriteableDirectory((File)f);
        this.bdbEnvironment = new EnhancedEnvironment(f, config);
        this.classCatalog = this.bdbEnvironment.getClassCatalog();
        if (!create) {
            DbBackup dbBackup = new DbBackup((Environment)this.bdbEnvironment);
            dbBackup.startBackup();
            dbBackup.endBackup();
        }
    }

    public void closeDatabase(Database db) {
        try {
            this.closeDatabase(db.getDatabaseName());
        }
        catch (DatabaseException e) {
            LOGGER.log(Level.SEVERE, "Error getting db name", e);
        }
    }

    public void closeDatabase(String name) {
        DatabasePlusConfig dpc = this.databases.remove(name);
        if (dpc == null) {
            LOGGER.warning("No such database: " + name);
            return;
        }
        Database db = dpc.database;
        try {
            db.sync();
        }
        catch (DatabaseException e) {
            LOGGER.log(Level.WARNING, "Error syncing when closing db " + name, e);
        }
        try {
            db.close();
        }
        catch (DatabaseException e) {
            LOGGER.log(Level.WARNING, "Error closing db " + name, e);
        }
    }

    public Database openDatabase(String name, BdbConfig config, boolean usePriorData) throws DatabaseException {
        if (this.bdbEnvironment == null) {
            throw new IllegalStateException("BdbModule not started");
        }
        if (this.databases.containsKey(name)) {
            DatabasePlusConfig dpc = this.databases.get(name);
            if (dpc.config == config) {
                return dpc.database;
            }
            throw new IllegalStateException("Database already exists: " + name);
        }
        DatabasePlusConfig dpc = new DatabasePlusConfig();
        if (!usePriorData) {
            try {
                this.bdbEnvironment.truncateDatabase(null, name, false);
            }
            catch (DatabaseNotFoundException databaseNotFoundException) {
                // empty catch block
            }
        }
        dpc.database = this.bdbEnvironment.openDatabase(null, name, config.toDatabaseConfig());
        dpc.config = config;
        this.databases.put(name, dpc);
        return dpc.database;
    }

    public StoredClassCatalog getClassCatalog() {
        return this.classCatalog;
    }

    public <K extends Serializable> StoredQueue<K> getStoredQueue(String dbname, Class<K> clazz, boolean usePriorData) {
        try {
            Database queueDb = this.openDatabase(dbname, StoredQueue.databaseConfig(), usePriorData);
            return new StoredQueue<K>(queueDb, clazz, this.getClassCatalog());
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }

    public <V extends IdentityCacheable> ObjectIdentityBdbManualCache<V> getOIBCCache(String dbName, boolean recycle, Class<? extends V> valueClass) throws DatabaseException {
        if (!recycle) {
            try {
                this.bdbEnvironment.truncateDatabase(null, dbName, false);
            }
            catch (DatabaseNotFoundException databaseNotFoundException) {
                // empty catch block
            }
        }
        ObjectIdentityBdbManualCache oic = new ObjectIdentityBdbManualCache();
        oic.initialize(this.bdbEnvironment, dbName, valueClass, this.classCatalog);
        this.oiCaches.put(dbName, oic);
        return oic;
    }

    public <V extends IdentityCacheable> ObjectIdentityCache<V> getObjectCache(String dbName, boolean recycle, Class<V> valueClass) throws DatabaseException {
        return this.getObjectCache(dbName, recycle, valueClass, valueClass);
    }

    public <V extends IdentityCacheable> ObjectIdentityCache<V> getObjectCache(String dbName, boolean recycle, Class<V> declaredClass, Class<? extends V> valueClass) throws DatabaseException {
        ObjectIdentityBdbManualCache<? extends V> oic = this.oiCaches.get(dbName);
        if (oic != null) {
            return oic;
        }
        oic = this.getOIBCCache(dbName, recycle, valueClass);
        return oic;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    @Override
    public void startCheckpoint(Checkpoint checkpointInProgress) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doCheckpoint(final Checkpoint checkpointInProgress) throws IOException {
        for (ObjectIdentityCache oic : this.oiCaches.values()) {
            oic.sync();
        }
        try {
            for (DatabasePlusConfig dbc : this.databases.values()) {
                dbc.database.sync();
            }
            CheckpointConfig chkptConfig = new CheckpointConfig();
            chkptConfig.setForce(true);
            this.bdbEnvironment.checkpoint(chkptConfig);
            LOGGER.fine("Finished bdb checkpoint.");
            DbBackup dbBackup = new DbBackup((Environment)this.bdbEnvironment);
            try {
                dbBackup.startBackup();
                File envCpDir = new File(this.dir.getFile(), checkpointInProgress.getName());
                FileUtils.ensureWriteableDirectory((File)envCpDir);
                File logfilesList = new File(envCpDir, "jdbfiles.manifest");
                String[] filedata = dbBackup.getLogFilesInBackupSet();
                for (int i = 0; i < filedata.length; ++i) {
                    File f = new File(this.dir.getFile(), filedata[i]);
                    int n = i;
                    filedata[n] = filedata[n] + "," + f.length();
                    if (!this.getUseHardLinkCheckpoints()) continue;
                    File hardLink = new File(envCpDir, filedata[i]);
                    try {
                        Files.createLink(hardLink.toPath(), f.toPath().toAbsolutePath());
                        continue;
                    }
                    catch (IOException | UnsupportedOperationException e) {
                        LOGGER.log(Level.SEVERE, "unable to create required checkpoint link " + hardLink, e);
                    }
                }
                org.apache.commons.io.FileUtils.writeLines((File)logfilesList, Arrays.asList(filedata));
                LOGGER.fine("Finished processing bdb log files.");
            }
            finally {
                dbBackup.endBackup();
            }
        }
        catch (DatabaseException e) {
            throw new IOException(e);
        }
        if (checkpointInProgress.getForgetAllButLatest()) {
            File[] oldEnvCpDirs;
            for (File d : oldEnvCpDirs = this.dir.getFile().listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String name) {
                    return !name.equals(checkpointInProgress.getName()) && TextUtils.matches((String)"cp\\d{5}-\\d{14}", (CharSequence)name);
                }
            })) {
                org.apache.commons.io.FileUtils.deleteDirectory((File)d);
            }
        }
    }

    protected void doRecover() throws IOException {
        File cpDir = new File(this.dir.getFile(), this.recoveryCheckpoint.getName());
        File logfilesList = new File(cpDir, "jdbfiles.manifest");
        List filesAndLengths = org.apache.commons.io.FileUtils.readLines((File)logfilesList);
        HashMap<String, Long> retainLogfiles = new HashMap<String, Long>();
        for (String line : filesAndLengths) {
            String[] fileAndLength = line.split(",");
            long expectedLength = Long.valueOf(fileAndLength[1]);
            retainLogfiles.put(fileAndLength[0], expectedLength);
            File cpFile = new File(cpDir, line);
            File destFile = new File(this.dir.getFile(), fileAndLength[0]);
            if (!cpFile.exists()) continue;
            if (cpFile.length() != expectedLength) {
                LOGGER.warning(cpFile.getName() + " expected " + expectedLength + " actual " + cpFile.length());
            }
            if (destFile.exists() && !destFile.delete()) {
                LOGGER.log(Level.SEVERE, "unable to delete obstructing file " + destFile);
            }
            try {
                Files.createLink(destFile.toPath(), cpFile.toPath().toAbsolutePath());
            }
            catch (IOException | UnsupportedOperationException e) {
                LOGGER.log(Level.SEVERE, "unable to create required restore link " + destFile, e);
            }
        }
        IOFileFilter filter = FileFilterUtils.orFileFilter((IOFileFilter)FileFilterUtils.suffixFileFilter((String)".jdb"), (IOFileFilter)FileFilterUtils.suffixFileFilter((String)".del"));
        filter = FileFilterUtils.makeFileOnly((IOFileFilter)filter);
        for (File f : this.dir.getFile().listFiles((FileFilter)filter)) {
            if (retainLogfiles.containsKey(f.getName())) {
                long expectedLength = (Long)retainLogfiles.get(f.getName());
                if (f.length() != expectedLength) {
                    LOGGER.warning(f.getName() + " expected " + expectedLength + " actual " + f.length());
                }
                retainLogfiles.remove(f.getName());
                continue;
            }
            String undelName = f.getName().replace(".del", ".jdb");
            if (retainLogfiles.containsKey(undelName)) {
                long expectedLength = (Long)retainLogfiles.get(undelName);
                if (f.length() != expectedLength) {
                    LOGGER.warning(f.getName() + " expected " + expectedLength + " actual " + f.length());
                }
                if (!f.renameTo(new File(f.getParentFile(), undelName))) {
                    throw new IOException("Unable to rename " + f + " to " + undelName);
                }
                retainLogfiles.remove(undelName);
            }
            if (f.delete()) continue;
            LOGGER.warning("unable to delete " + f);
            FileUtils.moveAsideIfExists((File)f);
        }
        if (retainLogfiles.size() > 0) {
            LOGGER.severe("Checkpoint corrupt, needed log files missing: " + retainLogfiles);
        }
    }

    @Override
    public void finishCheckpoint(Checkpoint checkpointInProgress) {
    }

    @Override
    @Autowired(required=false)
    public void setRecoveryCheckpoint(Checkpoint checkpoint) {
        this.recoveryCheckpoint = checkpoint;
    }

    @Override
    public void close() {
        if (this.classCatalog == null) {
            return;
        }
        for (ObjectIdentityCache objectIdentityCache : this.oiCaches.values()) {
            try {
                objectIdentityCache.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error closing oiCache " + objectIdentityCache, e);
            }
        }
        ArrayList<String> dbNames = new ArrayList<String>(this.databases.keySet());
        for (String dbName : dbNames) {
            try {
                this.closeDatabase(dbName);
            }
            catch (Exception e) {
                LOGGER.log(Level.SEVERE, "Error closing db " + dbName, e);
            }
        }
        try {
            this.bdbEnvironment.sync();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error syncing when closing environment.", exception);
        }
        try {
            this.bdbEnvironment.close();
        }
        catch (Exception exception) {
            LOGGER.log(Level.SEVERE, "Error closing environment.", exception);
        }
    }

    public Database getDatabase(String name) {
        DatabasePlusConfig dpc = this.databases.get(name);
        if (dpc == null) {
            return null;
        }
        return dpc.database;
    }

    public <K, V> DisposableStoredSortedMap<K, V> getStoredMap(String dbName, Class<K> keyClass, Class<V> valueClass, boolean allowDuplicates, boolean usePriorData) {
        Database mapDb;
        BdbConfig config = new BdbConfig();
        config.setSortedDuplicates(allowDuplicates);
        config.setAllowCreate(!usePriorData);
        if (dbName == null) {
            dbName = "tempMap-" + System.identityHashCode(this) + "-" + this.sn;
            ++this.sn;
        }
        final String openName = dbName;
        try {
            mapDb = this.openDatabase(openName, config, usePriorData);
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        TupleBinding valueBinding = TupleBinding.getPrimitiveBinding(valueClass);
        if (valueBinding == null) {
            valueBinding = new SerialBinding((ClassCatalog)this.classCatalog, valueClass);
        }
        DisposableStoredSortedMap storedMap = new DisposableStoredSortedMap<K, V>(mapDb, (EntryBinding)TupleBinding.getPrimitiveBinding(keyClass), (EntryBinding)valueBinding, true){

            @Override
            public void dispose() {
                super.dispose();
                DatabasePlusConfig dpc = (DatabasePlusConfig)BdbModule.this.databases.remove(openName);
                if (dpc == null) {
                    LOGGER.log(Level.WARNING, "No such database: " + openName);
                }
            }
        };
        return storedMap;
    }

    public void destroy() throws Exception {
        this.close();
    }

    public static class BdbConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        protected boolean allowCreate;
        protected boolean sortedDuplicates;
        protected boolean transactional;
        protected boolean deferredWrite = true;

        public boolean isAllowCreate() {
            return this.allowCreate;
        }

        public void setAllowCreate(boolean allowCreate) {
            this.allowCreate = allowCreate;
        }

        public boolean getSortedDuplicates() {
            return this.sortedDuplicates;
        }

        public void setSortedDuplicates(boolean sortedDuplicates) {
            this.sortedDuplicates = sortedDuplicates;
        }

        public DatabaseConfig toDatabaseConfig() {
            DatabaseConfig result = new DatabaseConfig();
            result.setDeferredWrite(this.deferredWrite);
            result.setTransactional(this.transactional);
            result.setAllowCreate(this.allowCreate);
            result.setSortedDuplicates(this.sortedDuplicates);
            return result;
        }

        public boolean isTransactional() {
            return this.transactional;
        }

        public void setTransactional(boolean transactional) {
            this.transactional = transactional;
        }

        public void setDeferredWrite(boolean b) {
            this.deferredWrite = true;
        }
    }

    private static class DatabasePlusConfig
    implements Serializable {
        private static final long serialVersionUID = 1L;
        public transient Database database;
        public BdbConfig config;

        private DatabasePlusConfig() {
        }
    }
}

