/*
 * Decompiled with CFR 0.152.
 */
package org.archive.bdb;

import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.ClassCatalog;
import com.sleepycat.bind.serial.SerialBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Logger;
import org.archive.bdb.BdbModule;

public class StoredQueue<E extends Serializable>
extends AbstractQueue<E> {
    private static final Logger logger = Logger.getLogger(StoredQueue.class.getName());
    protected transient StoredSortedMap<Long, E> queueMap;
    protected transient Database queueDb;
    protected AtomicLong tailIndex;
    protected volatile transient E peekItem = null;

    public StoredQueue(Database db, Class<E> clsOrNull, StoredClassCatalog classCatalog) {
        this.hookupDatabase(db, clsOrNull, classCatalog);
        this.tailIndex = new AtomicLong(this.queueMap.isEmpty() ? 0L : (Long)this.queueMap.lastKey() + 1L);
    }

    public void hookupDatabase(Database db, Class<E> clsOrNull, StoredClassCatalog classCatalog) {
        TupleBinding valueBinding = TupleBinding.getPrimitiveBinding(clsOrNull);
        if (valueBinding == null) {
            valueBinding = new SerialBinding((ClassCatalog)classCatalog, clsOrNull);
        }
        this.queueDb = db;
        this.queueMap = new StoredSortedMap(db, (EntryBinding)TupleBinding.getPrimitiveBinding(Long.class), (EntryBinding)valueBinding, true);
    }

    @Override
    public Iterator<E> iterator() {
        return this.queueMap.values().iterator();
    }

    @Override
    public int size() {
        try {
            return Math.max(0, (int)(this.tailIndex.get() - (Long)this.queueMap.firstKey()));
        }
        catch (IllegalStateException ise) {
            return 0;
        }
        catch (NoSuchElementException nse) {
            return 0;
        }
        catch (NullPointerException npe) {
            return 0;
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.peekItem != null) {
            return false;
        }
        try {
            return this.queueMap.isEmpty();
        }
        catch (IllegalStateException de) {
            return true;
        }
    }

    @Override
    public boolean offer(E o) {
        long targetIndex = this.tailIndex.getAndIncrement();
        this.queueMap.put((Object)targetIndex, o);
        return true;
    }

    @Override
    public synchronized E peek() {
        if (this.peekItem == null) {
            if (this.queueMap.isEmpty()) {
                return null;
            }
            this.peekItem = (Serializable)this.queueMap.remove(this.queueMap.firstKey());
        }
        return this.peekItem;
    }

    @Override
    public synchronized E poll() {
        Object head = this.peek();
        this.peekItem = null;
        return (E)head;
    }

    public static BdbModule.BdbConfig databaseConfig() {
        BdbModule.BdbConfig dbConfig = new BdbModule.BdbConfig();
        dbConfig.setTransactional(false);
        dbConfig.setAllowCreate(true);
        return dbConfig;
    }

    public void close() {
        try {
            this.queueDb.sync();
            this.queueDb.close();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
    }
}

