/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.archive.format.warc.WARCConstants;
import org.archive.io.Warc2Arc;
import org.archive.io.arc.ARCReader;
import org.archive.io.arc.ARCReaderFactory;
import org.archive.io.arc.ARCRecord;
import org.archive.io.warc.WARCRecordInfo;
import org.archive.io.warc.WARCWriter;
import org.archive.io.warc.WARCWriterPoolSettings;
import org.archive.io.warc.WARCWriterPoolSettingsData;
import org.archive.uid.RecordIDGenerator;
import org.archive.uid.UUIDGenerator;
import org.archive.util.FileUtils;
import org.archive.util.anvl.ANVLRecord;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.ISODateTimeFormat;

public class Arc2Warc {
    protected RecordIDGenerator generator = new UUIDGenerator();

    private static void usage(HelpFormatter formatter, Options options, int exitCode) {
        formatter.printHelp("java org.archive.io.arc.Arc2Warc [--force] ARC_INPUT WARC_OUTPUT", options);
        System.exit(exitCode);
    }

    private static String getRevision() {
        return Warc2Arc.parseRevision("$Revision$");
    }

    public void transform(File arc, File warc, boolean force) throws IOException {
        FileUtils.assertReadable((File)arc);
        if (warc.exists() && !force) {
            throw new IOException("Target WARC already exists. Will not overwrite.");
        }
        ARCReader reader = ARCReaderFactory.get((File)arc, (boolean)false, (long)0L);
        this.transform(reader, warc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transform(ARCReader reader, File warc) throws IOException {
        Object writer = null;
        reader.setDigest(false);
        try {
            BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(warc));
            Iterator i = reader.iterator();
            ARCRecord firstRecord = (ARCRecord)i.next();
            ByteArrayOutputStream baos = new ByteArrayOutputStream((int)firstRecord.getHeader().getLength());
            firstRecord.dump((OutputStream)baos);
            ANVLRecord ar = new ANVLRecord();
            ar.addLabelValue("Filedesc", baos.toString());
            ArrayList<String> metadata = new ArrayList<String>(1);
            metadata.add(ar.toString());
            writer = new WARCWriter(new AtomicInteger(), (OutputStream)bos, warc, (WARCWriterPoolSettings)new WARCWriterPoolSettingsData("", "", -1L, reader.isCompressed(), null, metadata, this.generator));
            writer.writeWarcinfoRecord(warc.getName(), "Made from " + reader.getReaderIdentifier() + " by " + this.getClass().getName() + "/" + Arc2Warc.getRevision());
            while (i.hasNext()) {
                this.write((WARCWriter)writer, (ARCRecord)i.next());
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                Logger l = Logger.getLogger(writer.getClass().getName());
                Level oldLevel = l.getLevel();
                l.setLevel(Level.WARNING);
                try {
                    writer.close();
                }
                finally {
                    l.setLevel(oldLevel);
                }
            }
        }
    }

    protected void write(WARCWriter writer, ARCRecord r) throws IOException {
        WARCRecordInfo recordInfo = new WARCRecordInfo();
        recordInfo.setUrl(r.getHeader().getUrl());
        recordInfo.setContentStream((InputStream)r);
        recordInfo.setContentLength(r.getHeader().getLength());
        recordInfo.setEnforceLength(true);
        String arcDateString = r.getHeader().getDate();
        String warcDateString = DateTimeFormat.forPattern((String)"yyyyMMddHHmmss").withZone(DateTimeZone.UTC).parseDateTime(arcDateString).toString(ISODateTimeFormat.dateTimeNoMillis());
        recordInfo.setCreate14DigitDate(warcDateString);
        ANVLRecord ar = new ANVLRecord();
        String ip = (String)r.getHeader().getHeaderValue("ip-address");
        if (ip != null && ip.length() > 0) {
            ar.addLabelValue("IP-Address", ip);
            r.getMetaData();
        }
        recordInfo.setExtraHeaders(ar);
        if (r.getHeader().getContentBegin() > 0) {
            recordInfo.setType(WARCConstants.WARCRecordType.response);
            recordInfo.setMimetype("application/http; msgtype=response");
            recordInfo.setRecordId(this.generator.getRecordID());
        } else {
            recordInfo.setType(WARCConstants.WARCRecordType.resource);
            recordInfo.setMimetype(r.getHeader().getMimetype());
            recordInfo.setRecordId(((WARCWriterPoolSettings)writer.settings).getRecordIDGenerator().getRecordID());
        }
        writer.writeRecord(recordInfo);
    }

    public static void main(String[] args) throws ParseException, IOException, java.text.ParseException {
        Options options = new Options();
        options.addOption(new Option("h", "help", false, "Prints this message and exits."));
        options.addOption(new Option("f", "force", false, "Force overwrite of target file."));
        PosixParser parser = new PosixParser();
        CommandLine cmdline = parser.parse(options, args, false);
        List cmdlineArgs = cmdline.getArgList();
        Option[] cmdlineOptions = cmdline.getOptions();
        HelpFormatter formatter = new HelpFormatter();
        if (cmdlineArgs.size() <= 0) {
            Arc2Warc.usage(formatter, options, 0);
        }
        boolean force = false;
        block4: for (int i = 0; i < cmdlineOptions.length; ++i) {
            switch (cmdlineOptions[i].getId()) {
                case 104: {
                    Arc2Warc.usage(formatter, options, 0);
                    continue block4;
                }
                case 102: {
                    force = true;
                    continue block4;
                }
                default: {
                    throw new RuntimeException("Unexpected option: " + cmdlineOptions[i].getId());
                }
            }
        }
        if (cmdlineArgs.size() != 2) {
            Arc2Warc.usage(formatter, options, 0);
        }
        new Arc2Warc().transform(new File((String)cmdlineArgs.get(0)), new File((String)cmdlineArgs.get(1)), force);
    }
}

