/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import it.unimi.dsi.fastutil.io.FastBufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import org.apache.commons.lang.StringUtils;
import org.archive.checkpointing.Checkpoint;
import org.archive.util.ArchiveUtils;
import org.archive.util.FileUtils;
import org.archive.util.TextUtils;

public class CrawlerJournal
implements Closeable {
    private static final Logger LOGGER = Logger.getLogger(CrawlerJournal.class.getName());
    public static final String LOG_ERROR = "E ";
    public static final String LOG_TIMESTAMP = "T ";
    protected Writer out = null;
    protected long lines = 0L;
    protected int timestamp_interval = 0;
    protected File gzipFile = null;

    public CrawlerJournal(String path, String filename) throws IOException {
        this.gzipFile = new File(path, filename);
        this.out = this.initialize(this.gzipFile);
    }

    public CrawlerJournal(File file) throws IOException {
        this.gzipFile = file;
        this.out = this.initialize(this.gzipFile);
    }

    protected Writer initialize(File f) throws FileNotFoundException, IOException {
        FileUtils.moveAsideIfExists((File)f);
        return new OutputStreamWriter(new GZIPOutputStream((OutputStream)new FastBufferedOutputStream((OutputStream)new FileOutputStream(f), 32768)));
    }

    public synchronized void writeLine(String ... strs) {
        try {
            for (String s : strs) {
                this.out.write(s);
            }
            this.out.write("\n");
            this.noteLine();
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "problem writing journal line: " + StringUtils.join((Object[])strs), e);
        }
    }

    protected void noteLine() throws IOException {
        ++this.lines;
        this.considerTimestamp();
    }

    protected void considerTimestamp() throws IOException {
        if (this.timestamp_interval > 0 && this.lines % (long)this.timestamp_interval == 0L) {
            this.out.write(LOG_TIMESTAMP);
            this.out.write(ArchiveUtils.getLog14Date());
            this.out.write("\n");
        }
    }

    @Override
    public void close() {
        if (this.out == null) {
            return;
        }
        try {
            this.out.flush();
            this.out.close();
            this.out = null;
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "problem closing journal", e);
        }
    }

    public synchronized void seriousError(String err) {
        this.writeLine(LOG_ERROR + ArchiveUtils.getLog14Date() + " " + err + "\n");
    }

    public synchronized void rotateForCheckpoint(Checkpoint checkpointInProgress) {
        if (this.out == null || !this.gzipFile.exists()) {
            return;
        }
        this.close();
        File newName = new File(this.gzipFile.getParentFile(), this.gzipFile.getName() + "." + checkpointInProgress.getName());
        try {
            FileUtils.moveAsideIfExists((File)newName);
            if (checkpointInProgress.getForgetAllButLatest()) {
                Object[] oldCheckpointeds = this.gzipFile.getParentFile().listFiles(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        String regex = "^" + Pattern.quote(CrawlerJournal.this.gzipFile.getName()) + "\\.cp\\d{5}-\\d{14}$";
                        return TextUtils.matches((String)regex, (CharSequence)name);
                    }
                });
                Arrays.sort(oldCheckpointeds);
                for (int i = 1; i < oldCheckpointeds.length; ++i) {
                    FileUtils.appendTo((File)oldCheckpointeds[0], (File)oldCheckpointeds[i]);
                    ((File)oldCheckpointeds[i]).delete();
                }
                if (oldCheckpointeds.length > 0) {
                    FileUtils.appendTo((File)oldCheckpointeds[0], (File)this.gzipFile);
                    this.gzipFile.delete();
                    ((File)oldCheckpointeds[0]).renameTo(newName);
                } else {
                    this.gzipFile.renameTo(newName);
                }
            } else {
                this.gzipFile.renameTo(newName);
            }
            this.out = this.initialize(this.gzipFile);
        }
        catch (IOException ioe) {
            LOGGER.log(Level.SEVERE, "Problem rotating recovery journal", ioe);
        }
    }
}

