/*
 * Decompiled with CFR 0.152.
 */
package org.archive.net;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.net.ProtocolCommandEvent;
import org.apache.commons.net.ProtocolCommandListener;
import org.apache.commons.net.ftp.FTPClient;
import org.archive.util.IterableLineIterator;

public class ClientFTP
extends FTPClient
implements ProtocolCommandListener {
    private final Logger logger = Logger.getLogger(((Object)((Object)this)).getClass().getName());
    protected StringBuilder controlConversation = new StringBuilder();
    protected Socket dataSocket;

    public ClientFTP() {
        this.addProtocolCommandListener(this);
    }

    public Socket openDataConnection(int command, String path) throws IOException {
        try {
            this.dataSocket = this._openDataConnection_(command, path);
            if (this.dataSocket != null) {
                this.recordAdditionalInfo("Opened data connection to " + this.dataSocket.getInetAddress().getHostAddress() + ":" + this.dataSocket.getPort());
            }
            return this.dataSocket;
        }
        catch (IOException e) {
            if (this.getPassiveHost() != null) {
                this.recordAdditionalInfo("Failed to open data connection to " + this.getPassiveHost() + ":" + this.getPassivePort() + ": " + e.getMessage());
            } else {
                this.recordAdditionalInfo("Failed to open data connection: " + e.getMessage());
            }
            throw e;
        }
    }

    public void closeDataConnection() {
        if (this.dataSocket != null) {
            String dataHostPort = this.dataSocket.getInetAddress().getHostAddress() + ":" + this.dataSocket.getPort();
            try {
                this.dataSocket.close();
                this.recordAdditionalInfo("Closed data connection to " + dataHostPort);
            }
            catch (IOException e) {
                this.recordAdditionalInfo("Problem closing data connection to " + dataHostPort + ": " + e.getMessage());
            }
        }
    }

    protected void _connectAction_() throws IOException {
        try {
            this.recordAdditionalInfo("Opening control connection to " + this.getRemoteAddress().getHostAddress() + ":" + this.getRemotePort());
            super._connectAction_();
        }
        catch (IOException e) {
            this.recordAdditionalInfo("Failed to open control connection to " + this.getRemoteAddress().getHostAddress() + ":" + this.getRemotePort() + ": " + e.getMessage());
            throw e;
        }
    }

    public void disconnect() throws IOException {
        String remoteHostPort = this.getRemoteAddress().getHostAddress() + ":" + this.getRemotePort();
        super.disconnect();
        this.recordAdditionalInfo("Closed control connection to " + remoteHostPort);
    }

    public String getControlConversation() {
        return this.controlConversation.toString();
    }

    protected void recordControlMessage(String linePrefix, String message) {
        for (String line : new IterableLineIterator((Reader)new StringReader(message))) {
            this.controlConversation.append(linePrefix);
            this.controlConversation.append(line);
            this.controlConversation.append("\r\n");
            if (!this.logger.isLoggable(Level.FINEST)) continue;
            this.logger.finest(linePrefix + line);
        }
    }

    public void protocolCommandSent(ProtocolCommandEvent event) {
        this.recordControlMessage("> ", event.getMessage());
    }

    public void protocolReplyReceived(ProtocolCommandEvent event) {
        this.recordControlMessage("< ", event.getMessage());
    }

    private void recordAdditionalInfo(String message) {
        this.recordControlMessage("* ", message);
    }

    public String[] getReplyStrings() {
        return this._replyLines.toArray(new String[0]);
    }
}

