/*
 * Decompiled with CFR 0.152.
 */
package org.archive.net;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.SftpATTRS;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.logging.Logger;

public class ClientSFTP {
    private final Logger logger = Logger.getLogger(this.getClass().getName());
    protected StringBuilder controlConversation = new StringBuilder();
    protected Socket dataSocket;
    protected Session session = null;
    protected Channel channel = null;
    protected ChannelSftp channelSFTP = null;

    public ClientSFTP() {
        this.logger.setUseParentHandlers(true);
    }

    public String getControlConversation() {
        return this.controlConversation.toString();
    }

    public void connect(String username, String host, int port, String password) throws SocketException, IOException {
        JSch jSch = new JSch();
        try {
            this.session = jSch.getSession(username, host, port);
            this.session.setConfig("StrictHostKeyChecking", "no");
            this.session.setPassword(password);
            this.session.connect();
            this.logger.info("Connected to SFTP server " + host + ":" + port);
            this.controlConversation.append("Connected to SFTP server " + host + ":" + port);
        }
        catch (Exception exception) {
            this.logger.info("Unable to connect to SFTP server : " + exception.toString());
            this.controlConversation.append("Unable to connect to SFTP server : " + exception.toString());
            this.session.disconnect();
        }
    }

    public ChannelSftp openSFTPChannel() throws JSchException {
        this.channel = this.session.openChannel("sftp");
        this.channel.connect();
        this.channelSFTP = (ChannelSftp)this.channel;
        this.logger.info("***   SFTP Channel created.   ***");
        boolean bool = this.channelSFTP.isConnected();
        if (bool) {
            this.logger.info("channelSftp connected ");
        }
        return this.channelSFTP;
    }

    public boolean isConnected() {
        if (this.channelSFTP != null) {
            return this.channelSFTP.isConnected();
        }
        return false;
    }

    public ChannelSftp getChannelSftp() {
        return this.channelSFTP;
    }

    public void exit() {
        this.session.disconnect();
    }

    public boolean isDirectory(String paramString) throws Exception {
        SftpATTRS sftpATTRS = this.channelSFTP.stat(paramString);
        return sftpATTRS.isDir();
    }

    public void disconnect() {
        if (this.channelSFTP != null) {
            this.channelSFTP.exit();
            this.logger.info("channelSftp exit....");
        }
        if (this.session != null) {
            this.session.disconnect();
            this.logger.info("session disconnect....");
        }
        this.channelSFTP = null;
    }

    public Map<String, Boolean> getLsFileMap(String paramString) throws Exception {
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        Vector vector = this.channelSFTP.ls(paramString);
        for (ChannelSftp.LsEntry lsEntry : vector) {
            String str = lsEntry.getFilename();
            if (".".equals(str) || "..".equals(str)) continue;
            String str1 = paramString + "/" + str;
            boolean bool = this.isDirectory(str1);
            this.logger.info("fileName : " + str);
            hashMap.put(str, bool);
        }
        return hashMap;
    }

    protected boolean mkdir(String paramString) throws Exception {
        this.logger.info("channelSftp mkdir: " + paramString);
        this.channelSFTP.mkdir(paramString);
        return true;
    }

    public boolean cd(String paramString) throws Exception {
        this.logger.info("channelSftp cd : " + paramString);
        this.channelSFTP.cd(paramString);
        return true;
    }

    protected boolean put(FileInputStream paramFileInputStream, String paramString) throws Exception {
        this.logger.info("channelSftp put: " + paramString);
        this.channelSFTP.put((InputStream)paramFileInputStream, paramString);
        return true;
    }

    protected boolean downRemoteSingleFile(String src, String dest) throws Exception {
        FileOutputStream fileOutputStream = new FileOutputStream(dest);
        this.channelSFTP.get(src, (OutputStream)fileOutputStream);
        this.logger.info("channelSftp download file: " + src);
        return true;
    }

    protected boolean rm(String paramString) throws Exception {
        this.channelSFTP.rm(paramString);
        return true;
    }
}

