/*
 * Decompiled with CFR 0.152.
 */
package org.archive.net;

import com.esotericsoftware.kryo.DefaultSerializer;
import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import org.apache.commons.httpclient.URIException;
import org.archive.url.UsableURI;

@DefaultSerializer(value=KryoSerializer.class)
public class UURI
extends UsableURI {
    private static final long serialVersionUID = -8946640480772772310L;

    public UURI(String fixup, boolean b, String charset) throws URIException {
        super(fixup, b, charset);
    }

    public UURI(UsableURI base, UsableURI relative) throws URIException {
        super(base, relative);
    }

    protected UURI() {
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.writeUTF(this.toCustomString());
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.parseUriReference(stream.readUTF(), true);
    }

    public static class KryoSerializer
    extends Serializer<UURI> {
        public void write(Kryo kryo, Output output, UURI uuri) {
            output.writeString(uuri.toCustomString());
        }

        public UURI read(Kryo kryo, Input input, Class<? extends UURI> aClass) {
            UURI uuri = new UURI();
            try {
                uuri.parseUriReference(input.readString(), true);
            }
            catch (URIException e) {
                throw new RuntimeException("Error deserializing UURI", e);
            }
            return uuri;
        }
    }
}

