/*
 * Decompiled with CFR 0.152.
 */
package org.archive.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.logging.Logger;
import org.archive.spring.OverlayContext;

public class KeyedProperties
extends ConcurrentSkipListMap<String, Object> {
    private static final long serialVersionUID = 2L;
    private static final Logger logger = Logger.getLogger(KeyedProperties.class.getName());
    protected TreeSet<String> externalPaths = new TreeSet();
    protected static ThreadLocal<ArrayList<OverlayContext>> threadOverrides = new ThreadLocal<ArrayList<OverlayContext>>(){

        @Override
        protected ArrayList<OverlayContext> initialValue() {
            return new ArrayList<OverlayContext>();
        }
    };

    public void addExternalPath(String path) {
        this.externalPaths.add(path);
    }

    public Object get(String key) {
        ArrayList<OverlayContext> overlays = threadOverrides.get();
        for (int i = overlays.size() - 1; i >= 0; --i) {
            OverlayContext ocontext = overlays.get(i);
            for (int j = ocontext.getOverlayNames().size() - 1; j >= 0; --j) {
                String name = ocontext.getOverlayNames().get(j);
                Map<String, Object> m = ocontext.getOverlayMap(name);
                if (m != null) {
                    for (String ok : this.getOverrideKeys(key)) {
                        Object val = m.get(ok);
                        if (val == null) continue;
                        return val;
                    }
                    continue;
                }
                logger.warning("sheet '" + name + "' should apply but there is no such sheet!");
            }
        }
        return super.get(key);
    }

    protected List<String> getOverrideKeys(String key) {
        ArrayList<String> keys = new ArrayList<String>(this.externalPaths.size());
        for (String path : this.externalPaths) {
            keys.add(path + "." + key);
        }
        return keys;
    }

    public static void pushOverrideContext(OverlayContext ocontext) {
        threadOverrides.get().add(ocontext);
    }

    public static OverlayContext popOverridesContext() {
        return threadOverrides.get().remove(threadOverrides.get().size() - 1);
    }

    public static void clearAllOverrideContexts() {
        threadOverrides.get().clear();
    }

    public static void loadOverridesFrom(OverlayContext ocontext) {
        assert (ocontext.haveOverlayNamesBeenSet());
        KeyedProperties.pushOverrideContext(ocontext);
    }

    public static boolean clearOverridesFrom(OverlayContext ocontext) {
        return threadOverrides.get().remove(ocontext);
    }

    public static void withOverridesDo(OverlayContext ocontext, Runnable todo) {
        try {
            KeyedProperties.loadOverridesFrom(ocontext);
            todo.run();
        }
        finally {
            KeyedProperties.clearOverridesFrom(ocontext);
        }
    }

    public static boolean overridesActiveFrom(OverlayContext ocontext) {
        return threadOverrides.get().contains(ocontext);
    }
}

