/*
 * Decompiled with CFR 0.152.
 */
package org.archive.spring;

import java.beans.PropertyChangeEvent;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.archive.spring.HasKeyedProperties;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.annotation.Required;

public class Sheet
implements BeanFactoryAware,
BeanNameAware {
    private static final long serialVersionUID = 9129011082185864377L;
    protected String name;
    protected BeanFactory beanFactory;
    protected Map<String, Object> map = new ConcurrentHashMap<String, Object>();

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setBeanName(String name) {
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Map<String, Object> getMap() {
        return this.map;
    }

    @Required
    public void setMap(Map<String, Object> m) {
        this.map.clear();
        this.map.putAll(m);
    }

    public void prime() {
        for (String fullpath : this.map.keySet()) {
            HasKeyedProperties hkp;
            Object bean;
            int lastDot = fullpath.lastIndexOf(".");
            String beanPath = fullpath.substring(0, lastDot);
            String terminalProp = fullpath.substring(lastDot + 1);
            Object value = this.map.get(fullpath);
            int i = beanPath.indexOf(".");
            if (i < 0) {
                bean = this.beanFactory.getBean(beanPath);
            } else {
                String beanName = beanPath.substring(0, i);
                String propPath = beanPath.substring(i + 1);
                BeanWrapperImpl wrapper = new BeanWrapperImpl(this.beanFactory.getBean(beanName));
                bean = wrapper.getPropertyValue(propPath);
            }
            try {
                hkp = (HasKeyedProperties)bean;
            }
            catch (ClassCastException cce) {
                throw new TypeMismatchException(bean, HasKeyedProperties.class, (Throwable)cce);
            }
            hkp.getKeyedProperties().addExternalPath(beanPath);
            BeanWrapperImpl wrapper = new BeanWrapperImpl((Object)hkp);
            Class requiredType = wrapper.getPropertyType(terminalProp);
            try {
                this.map.put(fullpath, wrapper.convertForProperty(value, terminalProp));
            }
            catch (TypeMismatchException tme) {
                TypeMismatchException tme2 = new TypeMismatchException(new PropertyChangeEvent(hkp, fullpath, wrapper.getPropertyValue(terminalProp), value), requiredType, (Throwable)tme);
                throw tme2;
            }
        }
    }
}

