/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import st.ata.util.FPGenerator;

public class LongToIntConsistentHash {
    protected static final int DEFAULT_REPLICAS = 128;
    protected TreeMap<Long, Integer> circle = new TreeMap();
    protected int replicasInstalledUpTo = -1;
    protected int numReplicas;

    public LongToIntConsistentHash() {
        this(128);
    }

    public LongToIntConsistentHash(int numReplicas) {
        this.numReplicas = numReplicas;
        this.installReplicas(0);
        this.replicasInstalledUpTo = 1;
    }

    public void installReplicasUpTo(int upTo) {
        if (this.replicasInstalledUpTo > upTo) {
            return;
        }
        while (this.replicasInstalledUpTo < upTo) {
            this.installReplicas(this.replicasInstalledUpTo);
            ++this.replicasInstalledUpTo;
        }
    }

    private void installReplicas(int bucket) {
        for (int i = 0; i < this.numReplicas; ++i) {
            this.circle.put(this.replicaLocation(bucket, i), bucket);
        }
    }

    protected long replicaLocation(int bucketNumber, int replicaNumber) {
        return FPGenerator.std64.fp(bucketNumber + "." + replicaNumber);
    }

    protected long hash(CharSequence cs) {
        return FPGenerator.std64.fp(cs);
    }

    public int bucketFor(long longHash, int upTo) {
        this.installReplicasUpTo(upTo);
        NavigableMap<Long, Integer> tailMap = this.circle.tailMap(longHash, true);
        Map.Entry match = null;
        for (Map.Entry candidate : tailMap.entrySet()) {
            if ((Integer)candidate.getValue() >= upTo) continue;
            match = candidate;
            break;
        }
        if (match == null) {
            return this.bucketFor(Long.MIN_VALUE, upTo);
        }
        return (Integer)match.getValue();
    }

    public int bucketFor(CharSequence cs, int upTo) {
        return this.bucketFor(this.hash(cs), upTo);
    }

    public int bucketFor(char[] chars, int upTo) {
        return this.bucketFor(this.hash(new String(chars)), upTo);
    }
}

