/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.archive.util.IdentityCacheable;
import org.archive.util.ObjectIdentityCache;
import org.archive.util.Supplier;

public class ObjectIdentityMemCache<V extends IdentityCacheable>
implements ObjectIdentityCache<V> {
    protected ConcurrentHashMap<String, V> map;

    public ObjectIdentityMemCache() {
        this.map = new ConcurrentHashMap();
    }

    public ObjectIdentityMemCache(int cap, float load, int conc) {
        this.map = new ConcurrentHashMap(cap, load, conc);
    }

    @Override
    public void close() {
    }

    @Override
    public V get(String key) {
        return this.getOrUse(key, null);
    }

    @Override
    public V getOrUse(String key, Supplier<V> supplierOrNull) {
        IdentityCacheable prevVal;
        IdentityCacheable val = (IdentityCacheable)this.map.get(key);
        if (val == null && supplierOrNull != null && (prevVal = this.map.putIfAbsent(key, val = (IdentityCacheable)supplierOrNull.get())) != null) {
            val = prevVal;
        }
        if (val != null) {
            val.setIdentityCache(this);
        }
        return (V)val;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }

    @Override
    public void sync() {
    }

    @Override
    public void dirtyKey(String key) {
    }

    public Map<String, V> getMap() {
        return this.map;
    }
}

