/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;

public class OneLineSimpleLogger
extends SimpleFormatter {
    private Date date = new Date();
    private FieldPosition position = new FieldPosition(0);
    private SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
    private StringBuffer buffer = new StringBuffer();

    @Override
    public synchronized String format(LogRecord record) {
        this.buffer.setLength(0);
        this.date.setTime(record.getMillis());
        this.position.setBeginIndex(0);
        this.formatter.format(this.date, this.buffer, this.position);
        this.buffer.append(' ');
        this.buffer.append(record.getLevel().getLocalizedName());
        this.buffer.append(" thread-");
        this.buffer.append(record.getThreadID());
        this.buffer.append(' ');
        if (record.getSourceClassName() != null) {
            this.buffer.append(record.getSourceClassName());
        } else {
            this.buffer.append(record.getLoggerName());
        }
        this.buffer.append('.');
        String methodName = record.getSourceMethodName();
        methodName = methodName == null || methodName.length() <= 0 ? "-" : methodName;
        this.buffer.append(methodName);
        this.buffer.append("() ");
        this.buffer.append(this.formatMessage(record));
        this.buffer.append(System.getProperty("line.separator"));
        if (record.getThrown() != null) {
            try {
                StringWriter writer = new StringWriter();
                PrintWriter printer = new PrintWriter(writer);
                record.getThrown().printStackTrace(printer);
                writer.close();
                this.buffer.append(writer.toString());
            }
            catch (Exception e) {
                this.buffer.append("Failed to get stack trace: " + e.getMessage());
            }
        }
        return this.buffer.toString();
    }

    public static Logger setConsoleHandler() {
        Logger logger = Logger.getLogger("");
        Handler[] hs = logger.getHandlers();
        for (int i = 0; i < hs.length; ++i) {
            Handler h = hs[0];
            if (!(h instanceof ConsoleHandler)) continue;
            h.setFormatter(new OneLineSimpleLogger());
        }
        return logger;
    }

    public static void main(String[] args) {
        Logger logger = OneLineSimpleLogger.setConsoleHandler();
        logger = Logger.getLogger("Test");
        logger.severe("Does this come out?");
        logger.severe("Does this come out?");
        logger.severe("Does this come out?");
        logger.log(Level.SEVERE, "hello", new RuntimeException("test"));
    }
}

