/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.iterator;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CompositeIterator<E>
implements Iterator<E> {
    protected ArrayList<Iterator<E>> iterators = new ArrayList();
    protected Iterator<E> currentIterator;
    protected int indexOfCurrentIterator = -1;

    private boolean nextIterator() {
        if (++this.indexOfCurrentIterator < this.iterators.size()) {
            this.currentIterator = this.iterators.get(this.indexOfCurrentIterator);
            return this.hasNext();
        }
        this.currentIterator = null;
        return false;
    }

    @Override
    public boolean hasNext() {
        if (this.currentIterator != null && this.currentIterator.hasNext()) {
            return true;
        }
        return this.nextIterator();
    }

    @Override
    public E next() {
        if (this.hasNext()) {
            return this.currentIterator.next();
        }
        throw new NoSuchElementException();
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    public CompositeIterator() {
    }

    public CompositeIterator(Iterator<E> i1, Iterator<E> i2) {
        this();
        this.add(i1);
        this.add(i2);
    }

    public void add(Iterator<E> i) {
        this.iterators.add(i);
    }
}

