/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.ms;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.io.Endian;
import org.archive.io.RandomAccessInputStream;
import org.archive.io.SeekInputStream;
import org.archive.io.SeekReader;
import org.archive.util.ms.BlockFileSystem;
import org.archive.util.ms.DefaultBlockFileSystem;
import org.archive.util.ms.Entry;
import org.archive.util.ms.PieceReader;
import org.archive.util.ms.PieceTable;

public class Doc {
    private static final Logger LOGGER = Logger.getLogger(Doc.class.getName());

    private Doc() {
    }

    public static SeekReader getText(String docFilename) throws IOException {
        return Doc.getText(new File(docFilename));
    }

    public static SeekReader getText(File doc) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(doc, "r");
        RandomAccessInputStream rais = new RandomAccessInputStream(raf);
        return Doc.getText((SeekInputStream)rais);
    }

    public static SeekReader getText(SeekInputStream doc) throws IOException {
        DefaultBlockFileSystem bfs = new DefaultBlockFileSystem(doc, 16);
        return Doc.getText(bfs, 20);
    }

    public static SeekReader getText(BlockFileSystem wordDoc, int cacheSize) throws IOException {
        List<Entry> entries = wordDoc.getRoot().list();
        Entry main = Doc.find(entries, "WordDocument");
        SeekInputStream mainStream = main.open();
        mainStream.position(10L);
        char flags = Endian.littleChar((InputStream)mainStream);
        boolean complex = (flags & 4) == 4;
        boolean tableOne = (flags & 0x200) == 512;
        String tableName = tableOne ? "1Table" : "0Table";
        Entry table = Doc.find(entries, tableName);
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Main entry:  " + main);
            LOGGER.finest("Table entry: " + table);
        }
        SeekInputStream tableStream = table.open();
        mainStream.position(24L);
        int fcMin = Endian.littleInt((InputStream)mainStream);
        int fcMax = Endian.littleInt((InputStream)mainStream);
        mainStream.position(76L);
        int cppText = Endian.littleInt((InputStream)mainStream);
        mainStream.position(418L);
        int fcClx = Endian.littleInt((InputStream)mainStream);
        int fcSz = Endian.littleInt((InputStream)mainStream);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("fcMin: " + fcMin);
            LOGGER.fine("fcMax: " + fcMax);
            LOGGER.fine("FcClx: " + fcClx);
            LOGGER.fine("szClx: " + fcSz);
            LOGGER.fine("complex: " + complex);
            LOGGER.fine("cppText: " + cppText);
        }
        PieceTable pt = new PieceTable(tableStream, fcClx, fcMax - fcMin, cacheSize);
        return new PieceReader(pt, mainStream);
    }

    private static Entry find(List<Entry> entries, String name) {
        for (Entry e : entries) {
            if (!e.getName().equals(name)) continue;
            return e;
        }
        return null;
    }
}

