/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.ms;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.io.BufferedSeekInputStream;
import org.archive.io.Endian;
import org.archive.io.OriginSeekInputStream;
import org.archive.io.SafeSeekInputStream;
import org.archive.io.SeekInputStream;
import org.archive.util.ms.Piece;

class PieceTable {
    private static final Logger LOGGER = Logger.getLogger(PieceTable.class.getName());
    protected static final int CP1252_INDICATOR = 0x40000000;
    protected static final int CP1252_MASK = 0x3FFFFFFF;
    private int count;
    private int maxCharPos;
    private int current;
    private Piece currentPiece;
    private SeekInputStream charPos;
    private SeekInputStream filePos;

    public PieceTable(SeekInputStream tableStream, int offset, int maxCharPos, int cachedRecords) throws IOException {
        long tp;
        tableStream.position((long)offset);
        PieceTable.skipProperties(tableStream);
        int sizeInBytes = Endian.littleInt((InputStream)tableStream);
        this.count = (sizeInBytes - 4) / 12;
        cachedRecords = Math.min(cachedRecords, this.count);
        long charPosStart = tp = tableStream.position() + 4L;
        long filePosStart = tp + (long)(this.count * 4) + 2L;
        this.filePos = this.wrap(tableStream, filePosStart, cachedRecords * 8);
        this.charPos = this.wrap(tableStream, charPosStart, cachedRecords * 4);
        this.maxCharPos = maxCharPos;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.finest("Size in bytes: " + sizeInBytes);
            LOGGER.finest("Piece table count: " + this.count);
            Piece piece = this.next();
            while (piece != null) {
                LOGGER.finest("#" + this.current + ": " + piece.toString());
                piece = this.next();
            }
            this.current = 0;
        }
    }

    private SeekInputStream wrap(SeekInputStream input, long pos, int cache) throws IOException {
        input.position(pos);
        SafeSeekInputStream r = new SafeSeekInputStream(input);
        r = new OriginSeekInputStream((SeekInputStream)r, pos);
        r = new BufferedSeekInputStream((SeekInputStream)r, cache);
        return r;
    }

    private static void skipProperties(SeekInputStream input) throws IOException {
        int tag = input.read();
        while (tag == 1) {
            int size = Endian.littleChar((InputStream)input);
            while (size > 0) {
                size = (int)((long)size - input.skip((long)size));
            }
            tag = input.read();
        }
        if (tag != 2) {
            throw new IllegalStateException();
        }
    }

    public int getMaxCharPos() {
        return this.maxCharPos;
    }

    public Piece next() throws IOException {
        Piece piece;
        int cp;
        if (this.current >= this.count) {
            this.currentPiece = null;
            return null;
        }
        if (this.current == this.count - 1) {
            cp = this.maxCharPos;
        } else {
            this.charPos.position((long)(this.current * 4));
            cp = Endian.littleInt((InputStream)this.charPos);
        }
        this.filePos.position((long)(this.current * 8));
        int encoded = Endian.littleInt((InputStream)this.filePos);
        if (LOGGER.isLoggable(Level.FINEST)) {
            StringBuffer sb = new StringBuffer(Integer.toBinaryString(encoded));
            while (sb.length() < 32) {
                sb.insert(0, '0');
            }
            LOGGER.finest("Encoded offset: " + sb.toString());
        }
        ++this.current;
        int start = this.currentPiece == null ? 0 : this.currentPiece.getCharPosLimit();
        if ((encoded & 0x40000000) == 0) {
            Piece piece2;
            this.currentPiece = piece2 = new Piece(encoded, start, cp, true);
            return piece2;
        }
        int filePos = (encoded & 0x3FFFFFFF) / 2;
        this.currentPiece = piece = new Piece(filePos, start, cp, false);
        return piece;
    }

    public Piece pieceFor(int charPos) throws IOException {
        if (this.currentPiece.contains(charPos)) {
            return this.currentPiece;
        }
        this.current = 0;
        this.currentPiece = null;
        this.next();
        while (this.currentPiece != null) {
            if (this.currentPiece.contains(charPos)) {
                return this.currentPiece;
            }
            this.next();
        }
        return null;
    }
}

