/*
 * Decompiled with CFR 0.152.
 */
package org.archive.bdb;

import com.sleepycat.bind.EntityBinding;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.collections.PrimaryKeyAssigner;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DisposableStoredSortedMap<K, V>
extends StoredSortedMap<K, V> {
    private static final Logger LOGGER = Logger.getLogger(DisposableStoredSortedMap.class.getName());
    protected Database db;

    public DisposableStoredSortedMap(Database db, EntryBinding<K> arg1, EntityBinding<V> arg2, boolean arg3) {
        super(db, arg1, arg2, arg3);
        this.db = db;
    }

    public DisposableStoredSortedMap(Database db, EntryBinding<K> arg1, EntityBinding<V> arg2, PrimaryKeyAssigner arg3) {
        super(db, arg1, arg2, arg3);
        this.db = db;
    }

    public DisposableStoredSortedMap(Database db, EntryBinding<K> arg1, EntryBinding<V> arg2, boolean arg3) {
        super(db, arg1, arg2, arg3);
        this.db = db;
    }

    public DisposableStoredSortedMap(Database db, EntryBinding<K> arg1, EntryBinding<V> arg2, PrimaryKeyAssigner arg3) {
        super(db, arg1, arg2, arg3);
        this.db = db;
    }

    public void dispose() {
        String name = null;
        try {
            if (this.db != null) {
                name = this.db.getDatabaseName();
                this.db.close();
                this.db.getEnvironment().removeDatabase(null, name);
                this.db = null;
            }
        }
        catch (DatabaseException e) {
            LOGGER.log(Level.WARNING, "Error closing db " + name, e);
        }
    }
}

