/*
 * Decompiled with CFR 0.152.
 */
package org.archive.bdb;

import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.Pool;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.je.DatabaseEntry;
import org.archive.bdb.AutoKryo;

public class KryoBinding<K>
implements EntryBinding<K> {
    private static final int POOL_SIZE = 8;
    protected final Class<K> baseClass;
    Pool<AutoKryo> kryoPool = new Pool<AutoKryo>(true, false, 8){

        protected AutoKryo create() {
            AutoKryo kryo = new AutoKryo();
            kryo.autoregister(KryoBinding.this.baseClass);
            kryo.setRegistrationRequired(false);
            kryo.setWarnUnregisteredClasses(true);
            return kryo;
        }
    };
    Pool<Output> outputPool = new Pool<Output>(true, false, 8){

        protected Output create() {
            return new Output(16384, -1);
        }
    };

    public KryoBinding(Class<K> baseClass) {
        this.baseClass = baseClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void objectToEntry(K object, DatabaseEntry entry) {
        AutoKryo kryo = (AutoKryo)((Object)this.kryoPool.obtain());
        try {
            Output output = (Output)this.outputPool.obtain();
            try {
                kryo.writeObject(output, object);
                entry.setData(output.toBytes());
            }
            finally {
                this.outputPool.free((Object)output);
            }
        }
        finally {
            this.kryoPool.free((Object)kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public K entryToObject(DatabaseEntry entry) {
        AutoKryo kryo = (AutoKryo)((Object)this.kryoPool.obtain());
        try {
            Object object = kryo.readObject(new Input(entry.getData()), this.baseClass);
            return (K)object;
        }
        finally {
            this.kryoPool.free((Object)kryo);
        }
    }
}

