/*
 * Decompiled with CFR 0.152.
 */
package org.archive.checkpointing;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.archive.spring.ConfigPath;
import org.archive.util.ArchiveUtils;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Required;

public class Checkpoint
implements InitializingBean {
    private static final Logger LOGGER = Logger.getLogger(Checkpoint.class.getName());
    public static final DecimalFormat INDEX_FORMAT = new DecimalFormat("00000");
    public static final String VALIDITY_STAMP_FILENAME = "valid";
    protected String name;
    protected String shortName;
    protected boolean success = false;
    protected ConfigPath checkpointDir = new ConfigPath("checkpoint directory", "");
    protected boolean forgetAllButLatest = false;

    public ConfigPath getCheckpointDir() {
        return this.checkpointDir;
    }

    @Required
    public void setCheckpointDir(ConfigPath checkpointsDir) {
        this.checkpointDir = checkpointsDir;
    }

    public void generateFrom(ConfigPath checkpointsDir, int nextCheckpointNumber) throws IOException {
        this.getCheckpointDir().setBase(checkpointsDir);
        this.getCheckpointDir().setPath("cp" + INDEX_FORMAT.format(nextCheckpointNumber) + "-" + ArchiveUtils.get14DigitDate());
        org.archive.util.FileUtils.ensureWriteableDirectory((File)this.getCheckpointDir().getFile());
        this.afterPropertiesSet();
    }

    public void afterPropertiesSet() {
        this.name = this.checkpointDir.getFile().getName();
        this.shortName = this.name.substring(0, this.name.indexOf("-"));
    }

    public void setSuccess(boolean b) {
        this.success = b;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public String getName() {
        return this.name;
    }

    public String getShortName() {
        return this.shortName;
    }

    public void writeValidity(String stamp) {
        if (!this.success) {
            return;
        }
        File valid = new File(this.checkpointDir.getFile(), VALIDITY_STAMP_FILENAME);
        try {
            FileUtils.writeStringToFile((File)valid, (String)stamp);
        }
        catch (IOException e) {
            valid.delete();
        }
    }

    public void saveJson(String beanName, JSONObject json) {
        try {
            File targetFile = new File(this.getCheckpointDir().getFile(), beanName);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("saving json to " + targetFile);
            }
            FileUtils.writeStringToFile((File)targetFile, (String)json.toString());
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "unable to save checkpoint JSON state of " + beanName, e);
            this.setSuccess(false);
        }
    }

    public JSONObject loadJson(String beanName) {
        File sourceFile = new File(this.getCheckpointDir().getFile(), beanName);
        try {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("reading json from " + sourceFile);
            }
            return new JSONObject(FileUtils.readFileToString((File)sourceFile));
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public BufferedWriter saveWriter(String beanName, String extraName) throws IOException {
        try {
            File targetFile = new File(this.getCheckpointDir().getFile(), beanName + "-" + extraName);
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("opening for writing: " + targetFile);
            }
            return new BufferedWriter(new FileWriter(targetFile));
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "unable to save checkpoint writer state " + extraName + " of " + beanName, e);
            this.setSuccess(false);
            throw e;
        }
    }

    public BufferedReader loadReader(String beanName, String extraName) throws IOException {
        File sourceFile = new File(this.getCheckpointDir().getFile(), beanName + "-" + extraName);
        return new BufferedReader(new FileReader(sourceFile));
    }

    public static boolean hasValidStamp(File checkpointDirectory) {
        return new File(checkpointDirectory, VALIDITY_STAMP_FILENAME).exists();
    }

    public void setForgetAllButLatest(boolean b) {
        this.forgetAllButLatest = b;
    }

    public boolean getForgetAllButLatest() {
        return this.forgetAllButLatest;
    }
}

