/*
 * Decompiled with CFR 0.152.
 */
package org.archive.io;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.archive.io.WriterPoolSettings;
import org.archive.io.arc.ARCWriter;
import org.archive.io.arc.WriterPoolSettingsData;
import org.archive.io.warc.WARCReader;
import org.archive.io.warc.WARCReaderFactory;
import org.archive.io.warc.WARCRecord;
import org.archive.util.ArchiveUtils;
import org.archive.util.FileUtils;

public class Warc2Arc {
    private static void usage(HelpFormatter formatter, Options options, int exitCode) {
        formatter.printHelp("java org.archive.io.arc.Warc2Arc [--force] [--prefix=PREFIX] [--suffix=SUFFIX] WARC_INPUT OUTPUT_DIR", options);
        System.exit(exitCode);
    }

    protected static String parseRevision(String version) {
        String ID = "$Revision: ";
        int index = version.indexOf("$Revision: ");
        return index < 0 ? version : version.substring(index + "$Revision: ".length(), version.length() - 1).trim();
    }

    private static String getRevision() {
        return Warc2Arc.parseRevision("$Revision$");
    }

    public void transform(File warc, File dir, String prefix, String suffix, boolean force) throws IOException, java.text.ParseException {
        FileUtils.assertReadable((File)warc);
        FileUtils.assertReadable((File)dir);
        WARCReader reader = WARCReaderFactory.get((File)warc);
        ArrayList<String> metadata = new ArrayList<String>();
        metadata.add("Made from " + reader.getReaderIdentifier() + " by " + this.getClass().getName() + "/" + Warc2Arc.getRevision());
        ARCWriter writer = new ARCWriter(new AtomicInteger(), (WriterPoolSettings)new WriterPoolSettingsData(prefix, suffix, -12L, reader.isCompressed(), Arrays.asList(dir), metadata));
        this.transform(reader, writer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void transform(WARCReader reader, ARCWriter writer) throws IOException, java.text.ParseException {
        reader.setDigest(false);
        Logger l = Logger.getLogger(writer.getClass().getName());
        Level oldLevel = l.getLevel();
        try {
            l.setLevel(Level.WARNING);
            for (WARCRecord r : reader) {
                if (!this.isARCType(r.getHeader().getMimetype()) || r.getHeader().getContentBegin() <= 0) continue;
                String ip = (String)r.getHeader().getHeaderValue("WARC-IP-Address");
                long length = r.getHeader().getLength();
                int offset = r.getHeader().getContentBegin();
                String mimetype = r.getHeader().getMimetype();
                String t = r.getHeader().getDate().replaceAll("[-T:Z]", "");
                long time = ArchiveUtils.getSecondsSinceEpoch((String)t).getTime();
                writer.write(r.getHeader().getUrl(), mimetype, ip, time, (long)((int)(length - (long)offset)), (InputStream)r);
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (writer != null) {
                try {
                    writer.close();
                }
                finally {
                    l.setLevel(oldLevel);
                }
            }
        }
    }

    protected boolean isARCType(String mimetype) {
        if (mimetype == null || mimetype.length() <= 0) {
            return false;
        }
        String cleaned = mimetype.toLowerCase().trim();
        return cleaned.equals("application/http; msgtype=response") || cleaned.equals("text/dns");
    }

    public static void main(String[] args) throws ParseException, IOException, java.text.ParseException {
        Options options = new Options();
        options.addOption(new Option("h", "help", false, "Prints this message and exits."));
        options.addOption(new Option("f", "force", false, "Force overwrite of target file."));
        options.addOption(new Option("p", "prefix", true, "Prefix to use on created ARC files, else uses default."));
        options.addOption(new Option("s", "suffix", true, "Suffix to use on created ARC files, else uses default."));
        PosixParser parser = new PosixParser();
        CommandLine cmdline = parser.parse(options, args, false);
        List cmdlineArgs = cmdline.getArgList();
        Option[] cmdlineOptions = cmdline.getOptions();
        HelpFormatter formatter = new HelpFormatter();
        if (cmdlineArgs.size() < 0) {
            Warc2Arc.usage(formatter, options, 0);
        }
        boolean force = false;
        String prefix = "WARC2ARC";
        String suffix = null;
        block6: for (int i = 0; i < cmdlineOptions.length; ++i) {
            switch (cmdlineOptions[i].getId()) {
                case 104: {
                    Warc2Arc.usage(formatter, options, 0);
                    continue block6;
                }
                case 102: {
                    force = true;
                    continue block6;
                }
                case 112: {
                    prefix = cmdlineOptions[i].getValue();
                    continue block6;
                }
                case 115: {
                    suffix = cmdlineOptions[i].getValue();
                    continue block6;
                }
                default: {
                    throw new RuntimeException("Unexpected option: " + cmdlineOptions[i].getId());
                }
            }
        }
        if (cmdlineArgs.size() != 2) {
            Warc2Arc.usage(formatter, options, 0);
        }
        new Warc2Arc().transform(new File(((String)cmdlineArgs.get(0)).toString()), new File(((String)cmdlineArgs.get(1)).toString()), prefix, suffix, force);
    }
}

