/*
 * Decompiled with CFR 0.152.
 */
package org.archive.spring;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class BeanFieldsPatternValidator
implements Validator {
    protected Class<?> clazz;
    protected List<PropertyPatternRule> rules;

    public BeanFieldsPatternValidator(Class<?> clazz, String ... fieldsPatterns) {
        this.clazz = clazz;
        if (fieldsPatterns.length % 3 != 0) {
            throw new IllegalArgumentException("variable arguments must be multiple of 3");
        }
        this.rules = new ArrayList<PropertyPatternRule>();
        for (int i = 0; i < fieldsPatterns.length; i += 3) {
            this.rules.add(new PropertyPatternRule(fieldsPatterns[i], fieldsPatterns[i + 1], fieldsPatterns[i + 2]));
        }
    }

    public boolean supports(Class<?> cls) {
        return this.clazz.isAssignableFrom(cls);
    }

    public void validate(Object target, Errors errors) {
        BeanWrapperImpl w = new BeanWrapperImpl(target);
        for (PropertyPatternRule rule : this.rules) {
            rule.test(w, errors);
        }
    }

    public class PropertyPatternRule {
        protected String propertyName;
        protected Pattern requiredPattern;
        protected String errorMessage;

        public PropertyPatternRule(String name, String pat, String msg) {
            this.propertyName = name;
            this.requiredPattern = Pattern.compile(pat);
            this.errorMessage = msg.replace("@@", pat);
        }

        public void test(BeanWrapperImpl wrapper, Errors errors) {
            Matcher m = this.requiredPattern.matcher((CharSequence)wrapper.getPropertyValue(this.propertyName));
            if (!m.matches()) {
                errors.rejectValue(this.propertyName, null, this.errorMessage);
            }
        }
    }
}

