/*
 * Decompiled with CFR 0.152.
 */
package org.archive.spring;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.archive.io.ReadSource;
import org.archive.spring.ConfigPath;
import org.archive.spring.WriteTarget;

public class ConfigFile
extends ConfigPath
implements ReadSource,
WriteTarget {
    private static final long serialVersionUID = 1L;

    public ConfigFile() {
    }

    public ConfigFile(String name, String path) {
        super(name, path);
    }

    public Reader obtainReader() {
        try {
            if (!this.getFile().exists()) {
                this.getFile().createNewFile();
            }
            if (this.configurer != null) {
                this.configurer.snapshotToLaunchDir(this.getFile());
            }
            return new InputStreamReader((InputStream)new FileInputStream(this.getFile()), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public Writer obtainWriter() {
        return this.obtainWriter(false);
    }

    @Override
    public Writer obtainWriter(boolean append) {
        try {
            return new OutputStreamWriter((OutputStream)new FileOutputStream(this.getFile(), append), "UTF-8");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

