/*
 * Decompiled with CFR 0.152.
 */
package org.archive.spring;

import java.io.File;
import java.io.Serializable;
import org.archive.spring.ConfigPathConfigurer;
import org.springframework.beans.factory.annotation.Required;

public class ConfigPath
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected String name;
    protected String path;
    protected ConfigPath base;
    protected ConfigPathConfigurer configurer;

    public ConfigPath() {
    }

    public ConfigPath(String name, String path) {
        this.name = name;
        this.path = path;
    }

    public ConfigPath getBase() {
        return this.base;
    }

    public void setBase(ConfigPath base) {
        this.base = base;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPath() {
        return this.path;
    }

    @Required
    public void setPath(String path) {
        this.path = path;
    }

    public File getFile() {
        String interpolatedPath = this.configurer != null ? this.configurer.interpolate(this.path) : this.path;
        return this.base == null || interpolatedPath.startsWith("/") ? new File(interpolatedPath) : new File(this.base.getFile(), interpolatedPath);
    }

    public ConfigPath merge(ConfigPath newvals) {
        if (newvals.name != null) {
            this.setName(newvals.getName());
        }
        if (newvals.path != null) {
            this.setPath(newvals.getPath());
        }
        return this;
    }

    public void setConfigurer(ConfigPathConfigurer configPathConfigurer) {
        this.configurer = configPathConfigurer;
    }
}

