/*
 * Decompiled with CFR 0.152.
 */
package org.archive.spring;

import java.beans.PropertyDescriptor;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.archive.spring.ConfigFile;
import org.archive.spring.ConfigPath;
import org.archive.spring.PathSharingContext;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.core.Ordered;

public class ConfigPathConfigurer
implements BeanPostProcessor,
ApplicationListener<ApplicationEvent>,
ApplicationContextAware,
Ordered {
    private static final Logger logger = Logger.getLogger(ConfigPathConfigurer.class.getName());
    protected Map<String, Object> allBeans = new HashMap<String, Object>();
    protected ConfigPath path;
    protected PathSharingContext appCtx;
    protected Map<String, ConfigPath> allConfigPaths = new HashMap<String, ConfigPath>();

    public ConfigPath getPath() {
        return this.path;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        this.allBeans.put(beanName, bean);
        return bean;
    }

    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof ContextRefreshedEvent) {
            for (String beanName : this.allBeans.keySet()) {
                this.fixupPaths(this.allBeans.get(beanName), beanName);
            }
            this.allBeans.clear();
        }
    }

    protected Object fixupPaths(Object bean, String beanName) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(bean);
        for (PropertyDescriptor d : wrapper.getPropertyDescriptors()) {
            Iterable iterable;
            if (d.getPropertyType().isAssignableFrom(ConfigPath.class) || d.getPropertyType().isAssignableFrom(ConfigFile.class)) {
                Object value = wrapper.getPropertyValue(d.getName());
                if (value == null || !(value instanceof ConfigPath)) continue;
                String patchName = beanName + "." + d.getName();
                this.fixupConfigPath((ConfigPath)value, patchName);
                continue;
            }
            if (!Iterable.class.isAssignableFrom(d.getPropertyType()) || (iterable = (Iterable)wrapper.getPropertyValue(d.getName())) == null) continue;
            int i = 0;
            for (Object candidate : iterable) {
                if (candidate != null && candidate instanceof ConfigPath) {
                    String patchName = beanName + "." + d.getName() + "[" + i + "]";
                    this.fixupConfigPath((ConfigPath)candidate, patchName);
                }
                ++i;
            }
        }
        return bean;
    }

    protected void fixupConfigPath(ConfigPath cp, String patchName) {
        if (cp.getBase() == null && cp != this.path) {
            cp.setBase(this.path);
        }
        if (StringUtils.isEmpty((String)cp.getName())) {
            cp.setName(patchName);
        }
        cp.setConfigurer(this);
        this.remember(patchName, cp);
    }

    public void setApplicationContext(ApplicationContext appCtx) throws BeansException {
        this.appCtx = (PathSharingContext)appCtx;
        String basePath = appCtx instanceof PathSharingContext ? this.appCtx.getConfigurationFile().getParent() : ".";
        this.path = new ConfigPath("job base", basePath);
        this.path.setConfigurer(this);
    }

    protected void remember(String key, ConfigPath cp) {
        this.allConfigPaths.put(key, cp);
    }

    public Map<String, ConfigPath> getAllConfigPaths() {
        return this.allConfigPaths;
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public int getOrder() {
        return Integer.MAX_VALUE;
    }

    public void snapshotToLaunchDir(File readFile) throws IOException {
        if (this.appCtx.getCurrentLaunchDir() == null || !this.appCtx.getCurrentLaunchDir().exists()) {
            logger.log(Level.WARNING, "launch directory unavailable to snapshot " + readFile);
            return;
        }
        FileUtils.copyFileToDirectory((File)readFile, (File)this.appCtx.getCurrentLaunchDir());
    }

    protected String interpolate(String rawPath) {
        if (this.appCtx.getCurrentLaunchId() != null) {
            return rawPath.replace("${launchId}", this.appCtx.getCurrentLaunchId());
        }
        return rawPath;
    }
}

