/*
 * Decompiled with CFR 0.152.
 */
package org.archive.spring;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.io.FileUtils;
import org.archive.spring.HasValidator;
import org.archive.spring.HeritrixLifecycleProcessor;
import org.archive.util.ArchiveUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.FileSystemXmlApplicationContext;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class PathSharingContext
extends FileSystemXmlApplicationContext {
    private static Logger LOGGER = Logger.getLogger(PathSharingContext.class.getName());
    protected HashMap<String, Errors> allErrors;
    protected transient String currentLaunchId;
    protected transient File currentLaunchDir;
    protected ConcurrentHashMap<Object, Object> data;

    public PathSharingContext(String configLocation) throws BeansException {
        super(configLocation);
    }

    public PathSharingContext(String[] configLocations, ApplicationContext parent) throws BeansException {
        super(configLocations, parent);
    }

    public PathSharingContext(String[] configLocations, boolean refresh, ApplicationContext parent) throws BeansException {
        super(configLocations, refresh, parent);
    }

    public PathSharingContext(String[] configLocations, boolean refresh) throws BeansException {
        super(configLocations, refresh);
    }

    public PathSharingContext(String[] configLocations) throws BeansException {
        super(configLocations);
    }

    public String getPrimaryConfigurationPath() {
        return this.getConfigLocations()[0];
    }

    public void validate() {
        this.allErrors = new HashMap();
        for (Map.Entry entry : this.getBeansOfType(HasValidator.class).entrySet()) {
            String name = (String)entry.getKey();
            HasValidator hv = (HasValidator)entry.getValue();
            Validator v = hv.getValidator();
            BeanPropertyBindingResult errors = new BeanPropertyBindingResult((Object)hv, name);
            v.validate((Object)hv, (Errors)errors);
            if (!errors.hasErrors()) continue;
            this.allErrors.put(name, (Errors)errors);
        }
        for (String name : this.allErrors.keySet()) {
            for (Object obj : this.allErrors.get(name).getAllErrors()) {
                LOGGER.fine("validation error for '" + name + "': " + obj);
            }
        }
    }

    public void start() {
        this.initLaunchDir();
        super.start();
    }

    public HashMap<String, Errors> getAllErrors() {
        return this.allErrors;
    }

    protected void initLaunchId() {
        this.currentLaunchId = ArchiveUtils.getUnique14DigitDate();
        LOGGER.info("launch id " + this.currentLaunchId);
    }

    public String getCurrentLaunchId() {
        return this.currentLaunchId;
    }

    public File getCurrentLaunchDir() {
        return this.currentLaunchDir;
    }

    protected File getConfigurationFile() {
        String primaryConfigurationPath = this.getPrimaryConfigurationPath();
        if (primaryConfigurationPath.startsWith("file:")) {
            try {
                return new File(new URI(primaryConfigurationPath));
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }
        return new File(primaryConfigurationPath);
    }

    protected void initLaunchDir() {
        this.initLaunchId();
        try {
            this.currentLaunchDir = new File(this.getConfigurationFile().getParentFile(), this.getCurrentLaunchId());
            if (!this.currentLaunchDir.mkdir()) {
                throw new IOException("failed to create directory " + this.currentLaunchDir);
            }
            FileUtils.copyFileToDirectory((File)this.getConfigurationFile(), (File)this.currentLaunchDir);
            File latestSymlink = new File(this.getConfigurationFile().getParentFile(), "latest");
            latestSymlink.delete();
            try {
                Files.createSymbolicLink(latestSymlink.toPath(), Paths.get(this.currentLaunchDir.getName(), new String[0]), new FileAttribute[0]);
            }
            catch (IOException | UnsupportedOperationException e) {
                LOGGER.log(Level.WARNING, "failed to create symlink from " + latestSymlink + " to " + this.currentLaunchDir, e);
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "failed to initialize launch directory: " + e);
            this.currentLaunchDir = null;
        }
    }

    protected void initLifecycleProcessor() {
        ConfigurableListableBeanFactory beanFactory = this.getBeanFactory();
        if (!beanFactory.containsLocalBean("lifecycleProcessor")) {
            HeritrixLifecycleProcessor obj = (HeritrixLifecycleProcessor)((Object)beanFactory.createBean(HeritrixLifecycleProcessor.class));
            beanFactory.registerSingleton("lifecycleProcessor", (Object)obj);
        }
        super.initLifecycleProcessor();
    }

    public ConcurrentHashMap<Object, Object> getData() {
        if (this.data == null) {
            this.data = new ConcurrentHashMap();
        }
        return this.data;
    }
}

