/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.hash.Funnel;
import com.google.common.hash.Funnels;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.Random;
import org.archive.util.BloomFilter;

public class BloomFilter64bit
implements Serializable,
BloomFilter {
    private static final long serialVersionUID = 3L;
    private final long expectedInserts;
    private int size;
    private final com.google.common.hash.BloomFilter<CharSequence> delegate;
    private final long bitSize;
    private final int numHashFunctions;

    public BloomFilter64bit(long n, int d) {
        this(n, d, new SecureRandom(), false);
    }

    public BloomFilter64bit(long n, int d, boolean roundUp) {
        this(n, d, new SecureRandom(), roundUp);
    }

    public BloomFilter64bit(long n, int d, Random weightsGenerator, boolean roundUp) {
        this.delegate = com.google.common.hash.BloomFilter.create((Funnel)Funnels.unencodedCharsFunnel(), (int)Ints.saturatedCast((long)n), (double)Math.pow(2.0, -d));
        this.expectedInserts = n;
        try {
            Method bitSizeMethod = this.delegate.getClass().getDeclaredMethod("bitSize", new Class[0]);
            bitSizeMethod.setAccessible(true);
            this.bitSize = (Long)bitSizeMethod.invoke(this.delegate, new Object[0]);
            Field numHashFunctionField = this.delegate.getClass().getDeclaredField("numHashFunctions");
            numHashFunctionField.setAccessible(true);
            this.numHashFunctions = numHashFunctionField.getInt(this.delegate);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean contains(CharSequence s) {
        return this.delegate.mightContain((Object)s);
    }

    @Override
    public boolean add(CharSequence s) {
        boolean added = this.delegate.put((Object)s);
        if (added) {
            ++this.size;
        }
        return added;
    }

    @Override
    public long getSizeBytes() {
        return this.bitSize / 8L;
    }

    @Override
    public long getExpectedInserts() {
        return this.expectedInserts;
    }

    @Override
    public long getHashCount() {
        return this.numHashFunctions;
    }

    @Override
    @VisibleForTesting
    public boolean getBit(long bitIndex) {
        try {
            Field bitsField = this.delegate.getClass().getDeclaredField("bits");
            bitsField.setAccessible(true);
            Object bitarray = bitsField.get(this.delegate);
            Method getBitMethod = bitarray.getClass().getDeclaredMethod("get", Long.TYPE);
            getBitMethod.setAccessible(true);
            return (Boolean)getBitMethod.invoke(bitarray, bitIndex);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

