/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;

public class Histotable<K>
extends TreeMap<K, Long> {
    private static final long serialVersionUID = 310306238032568623L;

    public Histotable() {
    }

    protected Histotable(Comparator<K> comparator) {
        super(comparator);
    }

    public void tally(K key) {
        this.tally(key, 1L);
    }

    public synchronized void tally(K key, long count) {
        long tally;
        long l = tally = this.containsKey(key) ? this.get(key) : 0L;
        if ((tally += count) != 0L) {
            this.put(key, tally);
        } else {
            this.remove(key);
        }
    }

    public static TreeSet<Map.Entry<?, Long>> getEntryByFrequencySortedSet() {
        TreeSet sorted = new TreeSet(new Comparator<Map.Entry<?, Long>>(){

            @Override
            public int compare(Map.Entry<?, Long> e1, Map.Entry<?, Long> e2) {
                long secondVal;
                long firstVal = e1.getValue();
                if (firstVal < (secondVal = e2.getValue().longValue())) {
                    return 1;
                }
                if (secondVal < firstVal) {
                    return -1;
                }
                String firstKey = e1.getKey().toString();
                String secondKey = e2.getKey().toString();
                return firstKey.compareTo(secondKey);
            }
        });
        return sorted;
    }

    public TreeSet<Map.Entry<?, Long>> getSortedByCounts() {
        TreeSet<Map.Entry<?, Long>> sorted = Histotable.getEntryByFrequencySortedSet();
        sorted.addAll(this.entrySet());
        return sorted;
    }

    public Set<Map.Entry<K, Long>> getSortedByKeys() {
        return this.entrySet();
    }

    public long getLargestValue() {
        long largest = 0L;
        for (Long el : this.values()) {
            if (el <= largest) continue;
            largest = el;
        }
        return largest;
    }

    public long getTotal() {
        long total = 0L;
        for (Long el : this.values()) {
            total += el.longValue();
        }
        return total;
    }

    public static String entryString(Object e) {
        Map.Entry entry = (Map.Entry)e;
        return entry.getValue() + " " + entry.getKey();
    }

    public long add(Histotable<K> ht) {
        long net = 0L;
        for (Object key : ht.keySet()) {
            long change = ht.get(key);
            net += change;
            this.tally(key, change);
        }
        return net;
    }

    public long subtract(Histotable<K> ht) {
        long net = 0L;
        for (Object key : ht.keySet()) {
            long change = ht.get(key);
            net -= change;
            this.tally(key, -change);
        }
        return net;
    }

    @Override
    public Long get(Object key) {
        Long val = (Long)super.get(key);
        return val == null ? 0L : val;
    }
}

