/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

public class JavaLiterals {
    public static String escape(String raw) {
        StringBuffer escaped = new StringBuffer();
        block10: for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            switch (c) {
                case '\b': {
                    escaped.append("\\b");
                    continue block10;
                }
                case '\t': {
                    escaped.append("\\t");
                    continue block10;
                }
                case '\n': {
                    escaped.append("\\n");
                    continue block10;
                }
                case '\f': {
                    escaped.append("\\f");
                    continue block10;
                }
                case '\r': {
                    escaped.append("\\r");
                    continue block10;
                }
                case '\"': {
                    escaped.append("\\\"");
                    continue block10;
                }
                case '\'': {
                    escaped.append("\\'");
                    continue block10;
                }
                case '\\': {
                    escaped.append("\\\\");
                    continue block10;
                }
                default: {
                    if (Character.getType(c) == 15) {
                        String unicode = Integer.toHexString(c);
                        while (unicode.length() < 4) {
                            unicode = "0" + unicode;
                        }
                        escaped.append("\\u" + unicode);
                        continue block10;
                    }
                    escaped.append(c);
                }
            }
        }
        return escaped.toString();
    }

    public static String unescape(String escaped) {
        StringBuffer raw = new StringBuffer();
        block13: for (int i = 0; i < escaped.length(); ++i) {
            char c = escaped.charAt(i);
            if (c != '\\') {
                raw.append(c);
                continue;
            }
            if (++i >= escaped.length()) {
                raw.append(c);
                continue;
            }
            c = escaped.charAt(i);
            switch (c) {
                case 'b': {
                    raw.append('\b');
                    continue block13;
                }
                case 't': {
                    raw.append('\t');
                    continue block13;
                }
                case 'n': {
                    raw.append('\n');
                    continue block13;
                }
                case 'f': {
                    raw.append('\f');
                    continue block13;
                }
                case 'r': {
                    raw.append('r');
                    continue block13;
                }
                case '\"': {
                    raw.append('\"');
                    continue block13;
                }
                case '\'': {
                    raw.append('\'');
                    continue block13;
                }
                case '\\': {
                    raw.append('\\');
                    continue block13;
                }
                case 'u': {
                    try {
                        int unicode = Integer.parseInt(escaped.substring(i + 1, i + 5), 16);
                        raw.append((char)unicode);
                        i += 4;
                    }
                    catch (IndexOutOfBoundsException e) {
                        raw.append("\\u");
                    }
                    continue block13;
                }
                default: {
                    if (!Character.isDigit(c)) continue block13;
                    int end = Math.min(i + 4, escaped.length());
                    int octal = Integer.parseInt(escaped.substring(i + 1, end), 8);
                    if (octal < 256) {
                        raw.append((char)octal);
                        i = end - 1;
                        continue block13;
                    }
                    raw.append('\\');
                    raw.append(c);
                }
            }
        }
        return raw.toString();
    }
}

