/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.CompoundName;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;

public class JndiUtils {
    private static final Properties COMPOUND_NAME_SYNTAX = new Properties();

    public static CompoundName getCompoundName(String name) throws InvalidNameException {
        return new CompoundName(name, COMPOUND_NAME_SYNTAX);
    }

    public static CompoundName getCompoundName(ObjectName on) throws NullPointerException, InvalidNameException {
        return JndiUtils.getCompoundName(on.getCanonicalKeyPropertyListString());
    }

    public static Reference getReference(ObjectName on) {
        Reference r = new Reference(String.class.getName());
        Hashtable<String, String> ht = on.getKeyPropertyList();
        r.add(new StringRefAddr("host", ht.get("host")));
        r.add(new StringRefAddr("name", ht.get("name")));
        r.add(new StringRefAddr("key", on.getCanonicalKeyPropertyListString()));
        return r;
    }

    public static Context getSubContext(String subContext) throws NamingException {
        return JndiUtils.getSubContext(JndiUtils.getCompoundName(subContext));
    }

    public static Context getSubContext(CompoundName subContext) throws NamingException {
        Context context = new InitialContext();
        try {
            context = (Context)context.lookup(subContext);
        }
        catch (NameNotFoundException e) {
            context = context.createSubcontext(subContext);
        }
        return context;
    }

    public static CompoundName bindObjectName(Context context, ObjectName on) throws NamingException, NullPointerException {
        CompoundName key = JndiUtils.getCompoundName(on);
        context.rebind(key, (Object)JndiUtils.getReference(on));
        return key;
    }

    public static CompoundName unbindObjectName(Context context, ObjectName on) throws NullPointerException, NamingException {
        CompoundName key = JndiUtils.getCompoundName(on);
        context.unbind(key);
        return key;
    }

    public static void main(String[] args) throws MalformedObjectNameException, NullPointerException, InvalidNameException, NamingException {
        ObjectName on = new ObjectName("org.archive.crawler:type=Service,name=Heritrix00,host=debord.archive.org");
        Context c = JndiUtils.getSubContext(JndiUtils.getCompoundName(on.getDomain()));
        CompoundName key = JndiUtils.bindObjectName(c, on);
        Reference r = (Reference)c.lookup(key);
        Enumeration<RefAddr> e = r.getAll();
        while (e.hasMoreElements()) {
            System.out.println(e.nextElement());
        }
        JndiUtils.unbindObjectName(c, on);
    }

    static {
        COMPOUND_NAME_SYNTAX.put("jndi.syntax.direction", "left_to_right");
        COMPOUND_NAME_SYNTAX.put("jndi.syntax.separator", "+");
        COMPOUND_NAME_SYNTAX.put("jndi.syntax.ignorecase", "false");
        COMPOUND_NAME_SYNTAX.put("jndi.syntax.escape", "\\");
        COMPOUND_NAME_SYNTAX.put("jndi.syntax.beginquote", "'");
        COMPOUND_NAME_SYNTAX.put("jndi.syntax.trimblanks", "true");
        COMPOUND_NAME_SYNTAX.put("jndi.syntax.separator.ava", ",");
        COMPOUND_NAME_SYNTAX.put("jndi.syntax.separator.typeval", "=");
    }
}

