/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import com.sleepycat.bind.EntryBinding;
import com.sleepycat.bind.serial.StoredClassCatalog;
import com.sleepycat.bind.tuple.TupleBinding;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.je.Database;
import com.sleepycat.je.DatabaseConfig;
import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.Environment;
import java.io.Closeable;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.bdb.KryoBinding;
import org.archive.util.IdentityCacheable;
import org.archive.util.ObjectIdentityCache;
import org.archive.util.Supplier;

public class ObjectIdentityBdbManualCache<V extends IdentityCacheable>
implements ObjectIdentityCache<V>,
Closeable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(ObjectIdentityBdbManualCache.class.getName());
    protected transient Database db;
    protected transient ConcurrentMap<String, V> memMap;
    protected transient StoredSortedMap<String, V> diskMap;
    protected transient ConcurrentMap<String, V> dirtyItems;
    protected AtomicLong count;
    private AtomicLong cacheHit = new AtomicLong(0L);
    private AtomicLong countOfGets = new AtomicLong(0L);
    private AtomicLong diskHit = new AtomicLong(0L);
    private AtomicLong supplierUsed = new AtomicLong(0L);
    private transient AtomicLong useStatsSyncUsed = new AtomicLong(0L);
    private AtomicLong evictions = new AtomicLong(0L);

    public ObjectIdentityBdbManualCache() {
        this.dirtyItems = CacheBuilder.newBuilder().maximumSize(10000L).expireAfterWrite(5L, TimeUnit.MINUTES).removalListener(new RemovalListener<String, V>(){

            public void onRemoval(RemovalNotification<String, V> stringVRemovalNotification) {
                ObjectIdentityBdbManualCache.this.evictions.incrementAndGet();
                ObjectIdentityBdbManualCache.this.diskMap.put(stringVRemovalNotification.getKey(), stringVRemovalNotification.getValue());
            }
        }).build().asMap();
    }

    public void initialize(Environment env, String dbName, Class valueClass, StoredClassCatalog classCatalog) throws DatabaseException {
        this.memMap = CacheBuilder.newBuilder().concurrencyLevel(64).initialCapacity(8192).softValues().build().asMap();
        this.db = this.openDatabase(env, dbName);
        this.diskMap = this.createDiskMap(this.db, classCatalog, valueClass);
        this.count = new AtomicLong(this.diskMap.size());
    }

    protected StoredSortedMap<String, V> createDiskMap(Database database, StoredClassCatalog classCatalog, Class valueClass) {
        TupleBinding keyBinding = TupleBinding.getPrimitiveBinding(String.class);
        Object valueBinding = TupleBinding.getPrimitiveBinding((Class)valueClass);
        if (valueBinding == null) {
            valueBinding = new KryoBinding(valueClass);
        }
        return new StoredSortedMap(database, (EntryBinding)keyBinding, (EntryBinding)valueBinding, true);
    }

    protected Database openDatabase(Environment environment, String dbName) throws DatabaseException {
        DatabaseConfig dbConfig = new DatabaseConfig();
        dbConfig.setTransactional(false);
        dbConfig.setAllowCreate(true);
        dbConfig.setDeferredWrite(true);
        return environment.openDatabase(null, dbName, dbConfig);
    }

    @Override
    public synchronized void close() {
        if (this.db != null) {
            try {
                this.sync();
                this.db.sync();
                this.db.close();
            }
            catch (DatabaseException e) {
                logger.log(Level.WARNING, "problem closing ObjectIdentityBdbCache", e);
            }
            finally {
                this.db = null;
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    @Override
    public V get(String key) {
        return this.getOrUse(key, null);
    }

    @Override
    public V getOrUse(String key, Supplier<V> supplierOrNull) {
        IdentityCacheable prevVal;
        IdentityCacheable val;
        this.countOfGets.incrementAndGet();
        if (this.countOfGets.get() % 10000L == 0L) {
            this.logCacheSummary();
        }
        if ((val = (IdentityCacheable)this.memMap.get(key)) != null) {
            this.cacheHit.incrementAndGet();
            val.setIdentityCache(this);
            return (V)val;
        }
        val = (IdentityCacheable)this.diskMap.get((Object)key);
        if (val == null) {
            if (supplierOrNull == null) {
                return null;
            }
            val = (IdentityCacheable)supplierOrNull.get();
            this.supplierUsed.incrementAndGet();
            prevVal = (IdentityCacheable)this.diskMap.putIfAbsent((Object)key, (Object)val);
            if (prevVal != null) {
                this.diskHit.incrementAndGet();
                val = prevVal;
            } else {
                this.count.incrementAndGet();
            }
        } else {
            this.diskHit.incrementAndGet();
        }
        prevVal = this.memMap.putIfAbsent(key, val);
        if (prevVal != null) {
            val = prevVal;
        }
        val.setIdentityCache(this);
        return (V)val;
    }

    @Override
    public Set<String> keySet() {
        return this.diskMap.keySet();
    }

    private void logCacheSummary() {
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(this.composeCacheSummary());
        }
    }

    protected String composeCacheSummary() {
        long totalHits = this.cacheHit.get() + this.diskHit.get();
        if (totalHits < 1L) {
            return "";
        }
        long cacheHitPercent = this.cacheHit.get() * 100L / totalHits;
        StringBuilder sb = new StringBuilder(120);
        sb.append("DB name:").append(this.getDatabaseName()).append(", ").append(" hit%: ").append(cacheHitPercent).append("%, gets=").append(this.countOfGets.get()).append(" memHits=").append(this.cacheHit.get()).append(" diskHits=").append(this.diskHit.get()).append(" supplieds=").append(this.supplierUsed.get()).append(" inMemItems=").append(this.memMap.size()).append(" dirtyItems=").append(this.dirtyItems.size()).append(" evictions=").append(this.evictions.get()).append(" syncs=").append(this.useStatsSyncUsed.get());
        return sb.toString();
    }

    @Override
    public int size() {
        if (this.db == null) {
            return 0;
        }
        return (int)this.count.get();
    }

    protected String getDatabaseName() {
        String name = "DbName-Lookup-Failed";
        try {
            if (this.db != null) {
                name = this.db.getDatabaseName();
            }
        }
        catch (DatabaseException databaseException) {
            // empty catch block
        }
        return name;
    }

    @Override
    public synchronized void sync() {
        String dbName = null;
        this.useStatsSyncUsed.incrementAndGet();
        long startTime = 0L;
        if (logger.isLoggable(Level.FINE)) {
            dbName = this.getDatabaseName();
            startTime = System.currentTimeMillis();
            logger.fine(dbName + " start sizes: disk " + this.diskMap.size() + ", mem " + this.memMap.size());
        }
        Iterator iter = this.dirtyItems.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            iter.remove();
            this.diskMap.put(entry.getKey(), entry.getValue());
        }
        try {
            this.db.sync();
        }
        catch (DatabaseException e) {
            throw new RuntimeException(e);
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.fine(dbName + " sync took " + (System.currentTimeMillis() - startTime) + "ms. Finish sizes: disk " + this.diskMap.size() + ", mem " + this.memMap.size());
        }
    }

    @Override
    public void dirtyKey(String key) {
        IdentityCacheable val = (IdentityCacheable)this.memMap.get(key);
        if (val == null) {
            logger.severe("dirty key not in memory should be impossible");
        }
        this.dirtyItems.put(key, val);
    }
}

