/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import com.sleepycat.collections.StoredSortedKeySet;
import com.sleepycat.collections.StoredSortedMap;
import com.sleepycat.collections.StoredSortedValueSet;
import java.util.LinkedList;
import java.util.List;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.lang.StringUtils;

public class PrefixFinder {
    public static List<String> find(SortedSet<String> set, String input) {
        LinkedList<String> result = new LinkedList<String>();
        set = PrefixFinder.headSetInclusive(set, input);
        String last = PrefixFinder.last(set);
        while (last != null) {
            if (input.startsWith(last)) {
                result.push(last);
                set = set.headSet(last);
            } else {
                int p = StringUtils.indexOfDifference((String)input, (String)last);
                if (p <= 0) {
                    return result;
                }
                last = input.substring(0, p);
                set = PrefixFinder.headSetInclusive(set, last);
            }
            last = PrefixFinder.last(set);
        }
        return result;
    }

    protected static SortedSet<String> headSetInclusive(SortedSet<String> set, String input) {
        if (set instanceof NavigableSet) {
            return ((NavigableSet)set).headSet(input, true);
        }
        if (set instanceof StoredSortedKeySet) {
            return ((StoredSortedKeySet)set).headSet((Object)input, true);
        }
        if (set instanceof StoredSortedValueSet) {
            return ((StoredSortedValueSet)set).headSet((Object)input, true);
        }
        return set.headSet(input + '\u0000');
    }

    private static String last(SortedSet<String> set) {
        return set.isEmpty() ? null : set.last();
    }

    public static List<String> findKeys(SortedMap<String, ?> map, String input) {
        LinkedList<String> result = new LinkedList<String>();
        map = PrefixFinder.headMapInclusive(map, input);
        String last = PrefixFinder.last(map);
        while (last != null) {
            if (input.startsWith(last)) {
                result.push(last);
                map = map.headMap(last);
            } else {
                int p = StringUtils.indexOfDifference((String)input, (String)last);
                if (p <= 0) {
                    return result;
                }
                last = input.substring(0, p);
                map = PrefixFinder.headMapInclusive(map, last);
            }
            last = PrefixFinder.last(map);
        }
        return result;
    }

    private static SortedMap<String, ?> headMapInclusive(SortedMap<String, ?> map, String input) {
        if (map instanceof NavigableMap) {
            return ((NavigableMap)map).headMap(input, true);
        }
        if (map instanceof StoredSortedMap) {
            return ((StoredSortedMap)map).headMap((Object)input, true);
        }
        return map.headMap(input + '\u0000');
    }

    private static String last(SortedMap<String, ?> map) {
        return map.isEmpty() ? null : map.lastKey();
    }
}

