/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.logging.Logger;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import org.archive.util.FileUtils;
import org.archive.util.TmpDirTestCase;

public class TestUtils {
    private static final Logger logger = Logger.getLogger(TestUtils.class.getName());

    public static void forceScarceMemory() {
        LinkedList<SoftReference<byte[]>> hog = new LinkedList<SoftReference<byte[]>>();
        long blocks = Runtime.getRuntime().maxMemory() / 1000000L;
        logger.info("forcing scarce memory via " + blocks + " 1MB blocks");
        for (long l = 0L; l <= blocks; ++l) {
            try {
                hog.add(new SoftReference<byte[]>(new byte[1000000]));
                continue;
            }
            catch (OutOfMemoryError e) {
                hog = null;
                logger.info("OOME triggered");
                break;
            }
        }
    }

    public static void testSerialization(Object proc) throws Exception {
        byte[] first = TestUtils.serialize(proc);
        ByteArrayInputStream binp = new ByteArrayInputStream(first);
        ObjectInputStream oinp = new ObjectInputStream(binp);
        Object o = oinp.readObject();
        oinp.close();
        TestCase.assertEquals(proc.getClass(), o.getClass());
        byte[] second = TestUtils.serialize(o);
        TestCase.assertTrue((boolean)Arrays.equals(first, second));
    }

    public static byte[] serialize(Object o) throws Exception {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        ObjectOutputStream oout = new ObjectOutputStream(bout);
        oout.writeObject(o);
        oout.close();
        return bout.toByteArray();
    }

    public static TestSuite makePackageSuite(Class<?> c) throws ClassNotFoundException {
        String cname = c.getName();
        int p = cname.lastIndexOf(46);
        String dir = cname.substring(0, p).replace('.', File.separatorChar);
        String root = "heritrix/src/test/java/".replace('/', File.separatorChar);
        File src = new File(root);
        return TestUtils.makeSuite(src, new File(root + dir));
    }

    public static TestSuite makeSuite(File srcRoot, File dir) throws ClassNotFoundException {
        TestSuite result = new TestSuite("All Tests");
        if (!dir.exists()) {
            throw new IllegalArgumentException(dir + " does not exist.");
        }
        TestUtils.scanSuite(result, srcRoot, dir);
        return result;
    }

    private static void scanSuite(TestSuite suite, File start, File dir) throws ClassNotFoundException {
        for (File f : dir.listFiles()) {
            String prefix;
            if (f.isDirectory() && !f.getName().startsWith(".")) {
                String prefix2 = start.getAbsolutePath();
                String full = f.getAbsolutePath();
                TestSuite sub = new TestSuite(full.substring(prefix2.length()));
                TestUtils.scanSuite(sub, start, f);
                if (sub.testCount() <= 0) continue;
                suite.addTest((Test)sub);
                continue;
            }
            if (!f.getName().endsWith("Test.java")) continue;
            String full = f.getAbsolutePath();
            String cname = full.substring((prefix = start.getAbsolutePath()).length());
            if (cname.startsWith(File.separator)) {
                cname = cname.substring(1);
            }
            cname = cname.replace(File.separatorChar, '.');
            cname = cname.substring(0, cname.length() - 5);
            suite.addTestSuite(Class.forName(cname));
        }
    }

    public static File tmpDir() throws IOException {
        String tmpDirStr = System.getProperty("testtmpdir");
        tmpDirStr = tmpDirStr == null ? TmpDirTestCase.DEFAULT_TEST_TMP_DIR : tmpDirStr;
        File tmpDir = new File(tmpDirStr);
        FileUtils.ensureWriteableDirectory((File)tmpDir);
        if (!tmpDir.canWrite()) {
            throw new IOException(tmpDir.getAbsolutePath() + " is unwriteable.");
        }
        tmpDir.deleteOnExit();
        return tmpDir;
    }
}

