/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.httpclient.URIException;
import org.archive.net.UURI;
import org.archive.url.LaxURLCodec;
import org.archive.util.ArchiveUtils;
import org.archive.util.TextUtils;

public class UriUtils {
    private static final Logger LOGGER = Logger.getLogger(UriUtils.class.getName());
    protected static final String NAIVE_LIKELY_URI_PATTERN = "[^<>]*[\\./][^<>]*";
    protected static final String[] AUDIO_VIDEO_IMAGE_MIMETYPES = new String[]{"audio/aiff", "audio/asf", "audio/basic", "audio/m4a", "audio/mid", "audio/midi", "audio/mp3", "audio/mp4", "audio/mp4a-latm", "audio/mpeg", "audio/mpeg3", "audio/mpegurl", "audio/mpg", "audio/ogg", "audio/playlist", "audio/unknown", "audio/vnd.qcelp", "audio/vnd.rn-realaudio", "audio/wav", "audio/x-aiff", "audio/x-m4a", "audio/x-midi", "audio/x-mp3", "audio/x-mpeg", "audio/x-mpeg3", "audio/x-mpegurl", "audio/x-ms-wax", "audio/x-ms-wma", "audio/x-ms-wmv", "audio/x-pn-realaudio", "audio/x-pn-realaudio-plugin", "audio/x-realaudio", "audio/x-scpls", "audio/x-wav", "image/bitmap", "image/bmp", "image/BMP", "image/cur", "image/fits", "image/gif", "image/GIF", "image/ico", "image/icon", "image/jp2", "image/jpeg", "image/JPEG", "image/jpeg-cmyk", "image/jpg", "image/JPG", "image/pdf", "image/pict", "image/pjpeg", "image/png", "image/PNG", "image/svg+xml", "image/tiff", "image/vnd.adobe.photoshop", "image/vnd.djvu", "image/vnd.dwg", "image/vnd.dxf", "image/vnd.microsoft.icon", "image/vnd.ms-modi", "image/vnd.ms-photo", "image/vnd.wap.wbmp", "image/x-bitmap", "image/x-bmp", "image/x-citrix-pjpeg", "image/x-dcraw", "image/x-djvu", "image/x.djvu", "image/x-emf", "image/x-eps", "image/x-guffaw", "image/x-ico", "image/xicon", "image/x-icon", "image/x-jg", "image/x-ms-bmp", "image/x-MS-bmp", "image/x-pcx", "image/x-photoshop", "image/x-pict", "image/x-png", "image/x-portable-anymap", "image/x-portable-bitmap", "image/x-portable-graymap", "image/x-portable-pixmap", "image/x-psd", "image/x-quicktime", "image/x-rgb", "image/x-windows-bmp", "image/x-wmf", "image/x-xbitmap", "image/x-xbm", "image/x-xfig", "image/x-xpixmap", "video/3gpp", "video/asx", "video/avi", "video/f4v", "video/flv", "video/m4v", "video/mp4", "video/MP4", "video/mp4v-es", "video/mpeg", "video/mpeg3", "video/mpeg4", "video/mpg4", "video/msvideo", "video/ogg", "video/quicktime", "video/swf", "video/unknown", "video/vnd.objectvideo", "video/webm", "video/wmv", "video/x-dv", "video/x-flv", "video/x-m4v", "video/x-mp4", "video/x-mpeg", "video/x-ms-asf", "video/x-ms-asx", "video/x-msvideo", "video/x-ms-wm", "video/x-ms-wma", "video/x-ms-wmv", "video/x-ms-wmx", "video/x-ms-wvx", "video/x-pn-realaudio", "video/x-pn-realvideo", "video/x-sgi-movie", "video/x-swf"};
    protected static final Set<String> AUDIO_VIDEO_IMAGE_MIMETYPE_SET = new HashSet<String>();
    protected static final Set<String> HTML_TAGS;
    protected static final Set<String> KNOWN_GOOD_FILE_EXTENSIONS;
    protected static final String QNV = "[a-zA-Z_]+=(?:[\\w-/.]|%[0-9a-fA-F]{2})*";
    protected static final String LIKELY_RELATIVE_URI_PATTERN = "(?:\\.?/)?(?:(?:[\\s\\w-]+|\\.\\.)(?:/))*([\\s\\w-]+(?:\\.[\\w-]+)??(\\.[a-zA-Z0-9]{2,5})?)?(?:\\?(?:[a-zA-Z_]+=(?:[\\w-/.]|%[0-9a-fA-F]{2})*)(?:&(?:[a-zA-Z_]+=(?:[\\w-/.]|%[0-9a-fA-F]{2})*))*)?(?:#[\\w-]+)?";
    protected static final String STRING_URI_DETECTOR = "(?:\\w|[\\.]{0,2}/)[\\S&&[^<>]]*(?:\\.|/)[\\S&&[^<>]]*(?:\\w|/)";
    protected static final String[] STRING_URI_DETECTOR_EXCEPTIONS;
    protected static final String LIKELY_URI_PATH = "(\\.{0,2}[^\\.\\n\\r\\s\"']*(\\.[^\\.\\n\\r\\s\"']+)+)";

    public static boolean isDataUri(CharSequence candidate) {
        return TextUtils.matches((String)"(?i)\\s*data:.*", (CharSequence)candidate);
    }

    public static boolean isPossibleUri(CharSequence candidate) {
        return TextUtils.matches((String)NAIVE_LIKELY_URI_PATTERN, (CharSequence)candidate);
    }

    public static boolean isLikelyUri(CharSequence candidate) {
        return UriUtils.isPossibleUri(candidate) && !UriUtils.isLikelyFalsePositive(candidate);
    }

    protected static boolean isLikelyFalsePositive(CharSequence candidate) {
        if (TextUtils.matches((String)"(?:text|application)/[^/]+", (CharSequence)candidate)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("rejected: looks like an application or text mimetype: " + candidate);
            }
            return true;
        }
        for (String s : AUDIO_VIDEO_IMAGE_MIMETYPES) {
            if (!s.contentEquals(candidate)) continue;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("rejected: looks like an audio video or image mimetype: " + candidate);
            }
            return true;
        }
        if (TextUtils.matches((String)"\\d+(?:\\.\\d+)*", (CharSequence)candidate)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("rejected: looks like a decimal number: " + candidate);
            }
            return true;
        }
        if (TextUtils.matches((String)".*[$()'\"\\[\\]{}|].*", (CharSequence)candidate)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("rejected: contains unusual characters: " + candidate);
            }
            return true;
        }
        if (TextUtils.matches((String)"^[,;+:].*|.*[.,;+:]$", (CharSequence)candidate)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("rejected: starts or ends with an unusual starting or ending character: " + candidate);
            }
            return true;
        }
        if (candidate.charAt(0) == '.' && !TextUtils.matches((String)"^\\.{1,2}/.*", (CharSequence)candidate)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("rejected: starts with '.' (but not './' or '../'): " + candidate);
            }
            return true;
        }
        if (TextUtils.matches((String)"^.*[^:]//.*$", (CharSequence)candidate)) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("rejected: contains '//' (but not '://'): " + candidate);
            }
            return true;
        }
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("accepted: does not look like a false positive: " + candidate);
        }
        return false;
    }

    public static String speculativeFixup(String candidate, UURI base) {
        Matcher m;
        String retVal = candidate;
        if (TextUtils.matches((String)"(?i)^https?%3A.*", (CharSequence)(retVal = TextUtils.replaceAll((String)"&amp;", (CharSequence)retVal, (String)"&")))) {
            try {
                retVal = LaxURLCodec.DEFAULT.decode(retVal);
            }
            catch (DecoderException e) {
                LOGGER.log(Level.INFO, "unable to decode", e);
            }
        }
        if ((m = TextUtils.getMatcher((String)"(?:[^./]+\\.)+([^./]+)(?:/.*)?", (CharSequence)retVal)).matches() && ArchiveUtils.isTld((String)m.group(1))) {
            String schemePlus = "http://";
            try {
                if (retVal.startsWith(base.getHost())) {
                    schemePlus = base.getScheme() + "://";
                }
            }
            catch (URIException uRIException) {
                // empty catch block
            }
            retVal = schemePlus + retVal;
        }
        TextUtils.recycleMatcher((Matcher)m);
        return retVal;
    }

    public static boolean isVeryLikelyUri(CharSequence candidate) {
        if (!TextUtils.matches((String)NAIVE_LIKELY_URI_PATTERN, (CharSequence)candidate)) {
            return false;
        }
        if (TextUtils.matches((String)"^(?i)https?://[^<>\\s/]+\\.[^<>\\s/]+(?:/[^<>\\s]*)?", (CharSequence)candidate)) {
            return true;
        }
        if (TextUtils.matches((String)"^//[^<>\\s/]+\\.[^<>\\s/]+(?:/[^<>\\s]*)?", (CharSequence)candidate)) {
            return true;
        }
        Matcher matcher = TextUtils.getMatcher((String)LIKELY_RELATIVE_URI_PATTERN, (CharSequence)candidate);
        if (!matcher.matches()) {
            return false;
        }
        String filename = matcher.group(1);
        String extension = matcher.group(2);
        if (filename != null && extension != null && filename.indexOf(46) != filename.lastIndexOf(46) && !KNOWN_GOOD_FILE_EXTENSIONS.contains(extension)) {
            return false;
        }
        if (TextUtils.matches((String)".*\\s+.*", (CharSequence)candidate) && (extension == null || !KNOWN_GOOD_FILE_EXTENSIONS.contains(extension))) {
            return false;
        }
        if (TextUtils.matches((String)"(?:text|application)/[^/]+", (CharSequence)candidate)) {
            return false;
        }
        if (AUDIO_VIDEO_IMAGE_MIMETYPE_SET.contains(candidate)) {
            return false;
        }
        if (TextUtils.matches((String)"\\d+(?:\\.\\d+)*", (CharSequence)candidate)) {
            return false;
        }
        Matcher m = TextUtils.getMatcher((String)"([^./]+)\\.([^./]+)", (CharSequence)candidate);
        return !m.matches() || !HTML_TAGS.contains(m.group(1).toLowerCase());
    }

    public static boolean isLikelyUriJavascriptContextLegacy(CharSequence candidate) {
        if (!TextUtils.matches((String)STRING_URI_DETECTOR, (CharSequence)candidate)) {
            return false;
        }
        for (String s : STRING_URI_DETECTOR_EXCEPTIONS) {
            if (!s.contentEquals(candidate)) continue;
            return false;
        }
        return true;
    }

    public static boolean isLikelyUriHtmlContextLegacy(CharSequence candidate) {
        return TextUtils.matches((String)LIKELY_URI_PATH, (CharSequence)candidate);
    }

    static {
        AUDIO_VIDEO_IMAGE_MIMETYPE_SET.addAll(Arrays.asList(AUDIO_VIDEO_IMAGE_MIMETYPES));
        HTML_TAGS = new HashSet<String>();
        HTML_TAGS.addAll(Arrays.asList("a", "abbr", "acronym", "address", "applet", "area", "article", "aside", "audio", "b", "base", "basefont", "bdi", "bdo", "big", "blockquote", "body", "br", "button", "canvas", "caption", "center", "cite", "code", "col", "colgroup", "command", "datalist", "dd", "del", "details", "dfn", "dir", "div", "dl", "dt", "em", "embed", "fieldset", "figcaption", "figure", "font", "footer", "form", "frame", "frameset", "head", "header", "hgroup", "h1", "h2", "h3", "h4", "h5", "h6", "hr", "html", "i", "iframe", "img", "input", "ins", "kbd", "keygen", "label", "legend", "li", "link", "map", "mark", "menu", "meta", "meter", "nav", "noframes", "noscript", "object", "ol", "optgroup", "option", "output", "p", "param", "pre", "progress", "q", "rp", "rt", "ruby", "s", "samp", "script", "section", "select", "small", "source", "span", "strike", "strong", "style", "sub", "summary", "sup", "table", "tbody", "td", "textarea", "tfoot", "th", "thead", "time", "title", "tr", "track", "tt", "u", "ul", "var", "video", "wbr"));
        KNOWN_GOOD_FILE_EXTENSIONS = new HashSet<String>();
        KNOWN_GOOD_FILE_EXTENSIONS.addAll(Arrays.asList(".jpg", ".js", ".css", ".png", ".gif", ".swf", ".flv", ".mp4", ".mp3", ".jpeg", ".html", ".pdf"));
        STRING_URI_DETECTOR_EXCEPTIONS = new String[]{"text/javascript"};
    }
}

