/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.fingerprint;

import junit.framework.TestCase;
import org.archive.util.fingerprint.LongFPSet;

public abstract class LongFPSetTestCase
extends TestCase {
    private LongFPSet fpSet;

    public LongFPSetTestCase(String testName) {
        super(testName);
    }

    public void setUp() {
        this.fpSet = this.makeLongFPSet();
    }

    protected abstract LongFPSet makeLongFPSet();

    public void testAdd() {
        long l1 = 1234L;
        long l2 = 2345L;
        LongFPSetTestCase.assertEquals((String)"empty set to start", (long)0L, (long)this.fpSet.count());
        LongFPSetTestCase.assertTrue((String)"set changed on addition of l1", (boolean)this.fpSet.add(l1));
        LongFPSetTestCase.assertTrue((String)"set changed on addition of l2", (boolean)this.fpSet.add(l2));
        LongFPSetTestCase.assertFalse((String)"set didn't change on re-addition of l1", (boolean)this.fpSet.add(l1));
    }

    public void testWithZero() {
        long zero = 0L;
        LongFPSetTestCase.assertEquals((String)"empty set to start", (long)0L, (long)this.fpSet.count());
        LongFPSetTestCase.assertFalse((String)"zero is not there", (boolean)this.fpSet.contains(zero));
        LongFPSetTestCase.assertTrue((String)"zero added", (boolean)this.fpSet.add(zero));
        LongFPSetTestCase.assertEquals((String)"one fp in set", (long)1L, (long)this.fpSet.count());
        LongFPSetTestCase.assertTrue((String)"zero is the element", (boolean)this.fpSet.contains(zero));
        LongFPSetTestCase.assertTrue((String)"zero removed", (boolean)this.fpSet.remove(zero));
        LongFPSetTestCase.assertEquals((String)"empty set again", (long)0L, (long)this.fpSet.count());
    }

    public void testContains() {
        long l1 = 1234L;
        long l2 = 2345L;
        long l3 = 1334L;
        LongFPSetTestCase.assertEquals((String)"empty set to start", (long)0L, (long)this.fpSet.count());
        this.fpSet.add(l1);
        this.fpSet.add(l2);
        LongFPSetTestCase.assertTrue((String)"contains l1", (boolean)this.fpSet.contains(l1));
        LongFPSetTestCase.assertTrue((String)"contains l2", (boolean)this.fpSet.contains(l2));
        LongFPSetTestCase.assertFalse((String)"does not contain l3", (boolean)this.fpSet.contains(l3));
    }

    public void testRemove() {
        long l1 = 1234L;
        LongFPSetTestCase.assertEquals((String)"empty set to start", (long)0L, (long)this.fpSet.count());
        LongFPSetTestCase.assertFalse((String)"fp not in set", (boolean)this.fpSet.remove(l1));
        this.fpSet.add(l1);
        LongFPSetTestCase.assertTrue((String)"fp was in set", (boolean)this.fpSet.remove(l1));
        LongFPSetTestCase.assertEquals((String)"empty set again", (long)0L, (long)this.fpSet.count());
    }

    public void testCount() {
        int i;
        int NUM = 1000;
        LongFPSetTestCase.assertEquals((String)"empty set to start", (long)0L, (long)this.fpSet.count());
        for (i = 1; i < 1000; ++i) {
            this.fpSet.add(i);
            LongFPSetTestCase.assertEquals((String)"correct num", (long)i, (long)this.fpSet.count());
        }
        for (i = 999; i > 0; --i) {
            this.fpSet.remove(i);
            LongFPSetTestCase.assertEquals((String)"correct num", (long)(i - 1), (long)this.fpSet.count());
        }
        LongFPSetTestCase.assertEquals((String)"empty set to start", (long)0L, (long)this.fpSet.count());
    }
}

