/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.ms;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;

class HeaderBlock {
    private ByteBuffer buffer;

    public HeaderBlock(ByteBuffer buffer) {
        this.buffer = buffer;
        buffer.order(ByteOrder.LITTLE_ENDIAN);
    }

    public long getFileType() {
        return this.buffer.getLong(0);
    }

    public int getBATCount() {
        return this.buffer.getInt(44);
    }

    public int getEntriesStart() {
        return this.buffer.getInt(48);
    }

    public int getSmallBATStart() {
        return this.buffer.getInt(60);
    }

    public int getSmallBATCount() {
        return this.buffer.getInt(64);
    }

    public int getExtendedBATStart() {
        return this.buffer.getInt(68);
    }

    public int getExtendedBATCount() {
        return this.buffer.getInt(72);
    }

    public int getBATBlockNumber(int block) {
        assert (block < 110);
        return this.buffer.getInt(76 + block * 4);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HeaderBlock{");
        sb.append("fileType=" + this.getFileType());
        sb.append(" propertiesStart=" + this.getEntriesStart());
        sb.append(" batCount=" + this.getBATCount());
        sb.append(" extendedBATStart=" + this.getExtendedBATStart());
        sb.append(" extendedBATCount=" + this.getExtendedBATCount());
        sb.append(" smallBATStart=" + this.getSmallBATStart());
        sb.append(" smallBATCount=" + this.getSmallBATCount());
        sb.append("}");
        return sb.toString();
    }
}

