/*
 * Decompiled with CFR 0.152.
 */
package org.archive.util.ms;

import java.io.IOException;
import java.io.InputStream;
import org.archive.io.Endian;
import org.archive.io.SeekInputStream;
import org.archive.io.SeekReader;
import org.archive.util.ms.Cp1252;
import org.archive.util.ms.Piece;
import org.archive.util.ms.PieceTable;

class PieceReader
extends SeekReader {
    private PieceTable table;
    private SeekInputStream doc;
    private boolean unicode;
    private int charPos;
    private int limit;

    public PieceReader(PieceTable table, SeekInputStream doc) throws IOException {
        this.table = table;
        this.doc = doc;
        this.charPos = 0;
        this.limit = -1;
    }

    private void seekIfNecessary() throws IOException {
        if (this.doc == null) {
            throw new IOException("Stream closed.");
        }
        if (this.charPos >= this.table.getMaxCharPos()) {
            return;
        }
        if (this.charPos < this.limit) {
            return;
        }
        Piece piece = this.table.next();
        this.unicode = piece.isUnicode();
        this.limit = piece.getCharPosLimit();
        this.doc.position((long)piece.getFilePos());
    }

    public int read() throws IOException {
        this.seekIfNecessary();
        if (this.doc == null) {
            throw new IOException("Stream closed.");
        }
        if (this.charPos >= this.table.getMaxCharPos()) {
            return -1;
        }
        char ch = this.unicode ? Endian.littleChar((InputStream)this.doc) : Cp1252.decode(this.doc.read());
        ++this.charPos;
        return ch;
    }

    public int read(char[] buf, int ofs, int len) throws IOException {
        this.seekIfNecessary();
        if (this.doc == null) {
            throw new IOException("Stream closed.");
        }
        if (this.charPos >= this.table.getMaxCharPos()) {
            return 0;
        }
        for (int i = 0; i < len; ++i) {
            int ch = this.read();
            if (ch < 0) {
                return i;
            }
            buf[ofs + i] = (char)ch;
        }
        return len;
    }

    public void close() throws IOException {
        this.doc.close();
        this.table = null;
    }

    public long position() throws IOException {
        return this.charPos;
    }

    public void position(long p) throws IOException {
        if (p > Integer.MAX_VALUE) {
            throw new IOException("File too large.");
        }
        int charPos = (int)p;
        Piece piece = this.table.pieceFor(charPos);
        if (piece == null) {
            throw new IOException("Illegal position: " + p);
        }
        this.unicode = piece.isUnicode();
        this.limit = piece.getCharPosLimit();
        int ofs = charPos - piece.getCharPosStart();
        this.charPos = charPos;
        this.doc.position((long)(piece.getFilePos() + ofs));
    }
}

