/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.File;
import org.archive.checkpointing.Checkpoint;
import org.archive.crawler.framework.CheckpointService;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class CheckpointValidator
implements Validator {
    public boolean supports(Class<?> cls) {
        return Checkpoint.class.isAssignableFrom(cls);
    }

    public void validate(Object target, Errors errors) {
        Checkpoint cp = ((CheckpointService)target).getRecoveryCheckpoint();
        if (cp == null) {
            return;
        }
        if (!Checkpoint.hasValidStamp((File)cp.getCheckpointDir().getFile())) {
            errors.rejectValue("recoveryCheckpoint.checkpointDir", null, "Configured recovery checkpoint " + cp.getName() + " incomplete: lacks valid stamp file.");
        }
    }
}

