/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.util.LinkedList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.archive.checkpointing.Checkpoint;
import org.archive.checkpointing.Checkpointable;
import org.archive.crawler.event.CrawlStateEvent;
import org.archive.crawler.framework.CrawlStatus;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.framework.ToePool;
import org.archive.crawler.reporting.AlertThreadGroup;
import org.archive.crawler.reporting.CrawlerLoggerModule;
import org.archive.crawler.reporting.StatisticsTracker;
import org.archive.modules.CandidateChain;
import org.archive.modules.CrawlMetadata;
import org.archive.modules.DispositionChain;
import org.archive.modules.FetchChain;
import org.archive.modules.net.ServerCache;
import org.archive.modules.seeds.SeedModule;
import org.archive.spring.ConfigPath;
import org.archive.util.ReportUtils;
import org.archive.util.Reporter;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.Lifecycle;
import org.springframework.context.support.AbstractApplicationContext;

public class CrawlController
implements Serializable,
Lifecycle,
ApplicationContextAware,
Checkpointable {
    private static final long serialVersionUID = 1L;
    protected AbstractApplicationContext appCtx;
    protected CrawlMetadata metadata;
    protected ServerCache serverCache;
    protected Frontier frontier;
    protected ConfigPath scratchDir = new ConfigPath("scratch subdirectory", "scratch");
    protected StatisticsTracker statisticsTracker;
    protected SeedModule seeds;
    protected FetchChain fetchChain;
    protected DispositionChain dispositionChain;
    protected CandidateChain candidateChain;
    protected int maxToeThreads;
    protected boolean runWhileEmpty = false;
    protected boolean pauseAtStart = true;
    protected int recorderOutBufferBytes = 16384;
    protected int recorderInBufferBytes = 524288;
    protected CrawlerLoggerModule loggerModule;
    private static final Logger LOGGER = Logger.getLogger(CrawlController.class.getName());
    private transient ToePool toePool;
    private transient LinkedList<byte[]> reserveMemory;
    private static final int RESERVE_BLOCKS = 1;
    private static final int RESERVE_BLOCK_SIZE = 0xC00000;
    private transient CrawlStatus sExit = CrawlStatus.CREATED;
    private transient State state = State.NASCENT;
    protected transient AlertThreadGroup alertThreadGroup;
    protected boolean isRunning = false;
    protected boolean hasStarted = false;
    protected boolean isStopComplete = false;
    protected Checkpoint recoveryCheckpoint;

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.appCtx = (AbstractApplicationContext)applicationContext;
    }

    public CrawlMetadata getMetadata() {
        return this.metadata;
    }

    @Autowired
    public void setMetadata(CrawlMetadata provider) {
        this.metadata = provider;
    }

    public ServerCache getServerCache() {
        return this.serverCache;
    }

    @Autowired
    public void setServerCache(ServerCache serverCache) {
        this.serverCache = serverCache;
    }

    public Frontier getFrontier() {
        return this.frontier;
    }

    @Autowired
    public void setFrontier(Frontier frontier) {
        this.frontier = frontier;
    }

    public ConfigPath getScratchDir() {
        return this.scratchDir;
    }

    public void setScratchDir(ConfigPath scratchDir) {
        this.scratchDir = scratchDir;
    }

    public StatisticsTracker getStatisticsTracker() {
        return this.statisticsTracker;
    }

    @Autowired
    public void setStatisticsTracker(StatisticsTracker statisticsTracker) {
        this.statisticsTracker = statisticsTracker;
    }

    public SeedModule getSeeds() {
        return this.seeds;
    }

    @Autowired
    public void setSeeds(SeedModule seeds) {
        this.seeds = seeds;
    }

    public FetchChain getFetchChain() {
        return this.fetchChain;
    }

    @Autowired
    public void setFetchChain(FetchChain fetchChain) {
        this.fetchChain = fetchChain;
    }

    public DispositionChain getDispositionChain() {
        return this.dispositionChain;
    }

    @Autowired
    public void setDispositionChain(DispositionChain dispositionChain) {
        this.dispositionChain = dispositionChain;
    }

    public CandidateChain getCandidateChain() {
        return this.candidateChain;
    }

    @Autowired
    public void setCandidateChain(CandidateChain candidateChain) {
        this.candidateChain = candidateChain;
    }

    public int getMaxToeThreads() {
        return this.maxToeThreads;
    }

    @Value(value="25")
    public void setMaxToeThreads(int maxToeThreads) {
        this.maxToeThreads = maxToeThreads;
        if (this.toePool != null) {
            this.toePool.setSize(this.maxToeThreads);
        }
    }

    public boolean getRunWhileEmpty() {
        return this.runWhileEmpty;
    }

    public void setRunWhileEmpty(boolean runWhileEmpty) {
        this.runWhileEmpty = runWhileEmpty;
    }

    public boolean getPauseAtStart() {
        return this.pauseAtStart;
    }

    public void setPauseAtStart(boolean pauseAtStart) {
        this.pauseAtStart = pauseAtStart;
    }

    public int getRecorderOutBufferBytes() {
        return this.recorderOutBufferBytes;
    }

    public void setRecorderOutBufferBytes(int recorderOutBufferBytes) {
        this.recorderOutBufferBytes = recorderOutBufferBytes;
    }

    public int getRecorderInBufferBytes() {
        return this.recorderInBufferBytes;
    }

    public void setRecorderInBufferBytes(int recorderInBufferBytes) {
        this.recorderInBufferBytes = recorderInBufferBytes;
    }

    public CrawlerLoggerModule getLoggerModule() {
        return this.loggerModule;
    }

    @Autowired
    public void setLoggerModule(CrawlerLoggerModule loggerModule) {
        this.loggerModule = loggerModule;
    }

    public void start() {
        AlertThreadGroup atg = AlertThreadGroup.current();
        if (atg != null) {
            this.alertThreadGroup = atg;
        }
        if (this.isRunning) {
            return;
        }
        this.sExit = CrawlStatus.FINISHED_ABNORMAL;
        this.reserveMemory = new LinkedList();
        for (int i = 0; i < 1; ++i) {
            this.reserveMemory.add(new byte[0xC00000]);
        }
        this.isRunning = true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
    }

    protected void sendCrawlStateChangeEvent(State newState, CrawlStatus status) {
        if (this.state == newState) {
            return;
        }
        this.state = newState;
        LOGGER.fine("reached CrawlController.State " + (Object)((Object)this.state) + ", notifying listeners");
        CrawlStateEvent event = new CrawlStateEvent(this, newState, status.getDescription());
        this.appCtx.publishEvent((ApplicationEvent)event);
    }

    public boolean hasStarted() {
        return this.hasStarted;
    }

    public boolean isStopComplete() {
        return this.isStopComplete;
    }

    public void requestCrawlStart() {
        this.hasStarted = true;
        this.sendCrawlStateChangeEvent(State.PREPARING, CrawlStatus.PREPARING);
        if (this.recoveryCheckpoint == null) {
            this.getSeeds().announceSeeds();
        }
        this.setupToePool();
        this.sExit = CrawlStatus.FINISHED_ABNORMAL;
        if (this.getPauseAtStart()) {
            this.completePause();
        } else {
            this.getFrontier().run();
        }
    }

    protected void completeStop() {
        if (!this.isRunning) {
            return;
        }
        LOGGER.fine("Entered complete stop.");
        this.statisticsTracker.getSnapshot();
        this.reserveMemory = null;
        if (this.toePool != null) {
            this.toePool.cleanup();
        }
        this.toePool = null;
        LOGGER.fine("Finished crawl.");
        try {
            if (this.appCtx.isRunning()) {
                this.appCtx.stop();
            }
        }
        catch (RuntimeException re) {
            LOGGER.log(Level.SEVERE, re.getMessage(), re);
        }
        this.sendCrawlStateChangeEvent(State.FINISHED, this.sExit);
        this.isStopComplete = true;
        this.appCtx.publishEvent((ApplicationEvent)new StopCompleteEvent(this));
    }

    protected synchronized void completePause() {
        this.sendCrawlStateChangeEvent(State.PAUSED, CrawlStatus.PAUSED);
    }

    private boolean shouldContinueCrawling() {
        Frontier frontier = this.getFrontier();
        if (frontier.isEmpty() && !this.getRunWhileEmpty()) {
            this.sExit = CrawlStatus.FINISHED;
            return false;
        }
        return this.isActive();
    }

    public synchronized void requestCrawlStop() {
        if (this.state == State.STOPPING) {
            this.getToePool().cleanup();
        }
        this.requestCrawlStop(CrawlStatus.ABORTED);
    }

    public synchronized void requestCrawlStop(CrawlStatus message) {
        if (this.state == State.NASCENT) {
            this.sExit = message;
            this.state = State.FINISHED;
            this.isStopComplete = true;
        }
        if (this.state == State.STOPPING || this.state == State.FINISHED) {
            return;
        }
        if (message == null) {
            throw new IllegalArgumentException("Message cannot be null.");
        }
        if (this.sExit != CrawlStatus.FINISHED) {
            this.sExit = message;
        }
        this.beginCrawlStop();
    }

    public void beginCrawlStop() {
        LOGGER.fine("Started.");
        this.sendCrawlStateChangeEvent(State.STOPPING, this.sExit);
        Frontier frontier = this.getFrontier();
        if (frontier != null) {
            frontier.terminate();
        }
        LOGGER.fine("Finished.");
    }

    public synchronized void requestCrawlPause() {
        if (this.state == State.PAUSING || this.state == State.PAUSED) {
            return;
        }
        this.sExit = CrawlStatus.WAITING_FOR_PAUSE;
        this.getFrontier().pause();
        this.sendCrawlStateChangeEvent(State.PAUSING, this.sExit);
    }

    public boolean isPaused() {
        return this.state == State.PAUSED;
    }

    public boolean isPausing() {
        return this.state == State.PAUSING;
    }

    public boolean isActive() {
        return this.state == State.RUNNING || this.state == State.EMPTY;
    }

    public boolean isFinished() {
        return this.state == State.FINISHED;
    }

    public void requestCrawlResume() {
        if (this.state != State.PAUSING && this.state != State.PAUSED) {
            return;
        }
        assert (this.toePool != null);
        Frontier f = this.getFrontier();
        f.unpause();
        this.sendCrawlStateChangeEvent(State.RUNNING, CrawlStatus.RUNNING);
    }

    public int getActiveToeCount() {
        if (this.toePool == null) {
            return 0;
        }
        return this.toePool.getActiveToeCount();
    }

    protected void setupToePool() {
        this.toePool = new ToePool(this.alertThreadGroup, this);
        this.toePool.setSize(this.getMaxToeThreads());
        this.toePool.waitForAll();
    }

    public int getToeCount() {
        return this.toePool == null ? 0 : this.toePool.getToeCount();
    }

    public ToePool getToePool() {
        return this.toePool;
    }

    public void killThread(int threadNumber, boolean replace) {
        this.toePool.killThread(threadNumber, replace);
    }

    public boolean atFinish() {
        return this.isActive() && !this.shouldContinueCrawling();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        this.state = State.PAUSED;
        stream.defaultReadObject();
    }

    public void freeReserveMemory() {
        if (!this.reserveMemory.isEmpty()) {
            this.reserveMemory.removeLast();
            System.gc();
        }
    }

    public void logProgressStatistics(String msg) {
        this.loggerModule.getProgressStats().info(msg);
    }

    public Object getState() {
        return this.state;
    }

    public CrawlStatus getCrawlExitStatus() {
        return this.sExit;
    }

    public String getToeThreadReport() {
        if (this.toePool == null) {
            return "no ToeThreads";
        }
        StringWriter sw = new StringWriter();
        this.toePool.reportTo(new PrintWriter(sw));
        return sw.toString();
    }

    public String getToeThreadReportShort() {
        return this.toePool == null ? "" : ReportUtils.shortReportLine((Reporter)this.toePool);
    }

    public Map<String, Object> getToeThreadReportShortData() {
        return this.toePool == null ? null : this.toePool.shortReportMap();
    }

    public String getFrontierReportShort() {
        return ReportUtils.shortReportLine((Reporter)this.getFrontier());
    }

    public void noteFrontierState(Frontier.State reachedState) {
        switch (reachedState) {
            case RUN: {
                LOGGER.info("Crawl running.");
                this.sendCrawlStateChangeEvent(State.RUNNING, CrawlStatus.RUNNING);
                break;
            }
            case EMPTY: {
                LOGGER.info("Crawl empty.");
                if (!this.getRunWhileEmpty()) {
                    this.sExit = CrawlStatus.FINISHED;
                    this.beginCrawlStop();
                }
                this.sendCrawlStateChangeEvent(State.EMPTY, CrawlStatus.RUNNING);
                break;
            }
            case PAUSE: {
                if (this.state != State.PAUSING) break;
                this.completePause();
                break;
            }
            case FINISH: {
                this.completeStop();
                break;
            }
        }
    }

    public void startCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void doCheckpoint(Checkpoint checkpointInProgress) throws IOException {
    }

    public void finishCheckpoint(Checkpoint checkpointInProgress) {
    }

    public void setRecoveryCheckpoint(Checkpoint recoveryCheckpoint) {
        this.recoveryCheckpoint = recoveryCheckpoint;
    }

    public static class StopCompleteEvent
    extends ApplicationEvent {
        private static final long serialVersionUID = 1L;

        public StopCompleteEvent(Object source) {
            super(source);
        }
    }

    public static enum State {
        NASCENT,
        RUNNING,
        EMPTY,
        PAUSED,
        PAUSING,
        STOPPING,
        FINISHED,
        PREPARING;

    }
}

