/*
 * Decompiled with CFR 0.152.
 */
package org.archive.crawler.framework;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.Semaphore;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.collections.ListUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.archive.crawler.event.CrawlStateEvent;
import org.archive.crawler.framework.CheckpointService;
import org.archive.crawler.framework.CheckpointSuccessEvent;
import org.archive.crawler.framework.CrawlController;
import org.archive.crawler.framework.Frontier;
import org.archive.crawler.reporting.AlertThreadGroup;
import org.archive.crawler.reporting.CrawlStatSnapshot;
import org.archive.crawler.reporting.StatisticsTracker;
import org.archive.spring.ConfigPath;
import org.archive.spring.ConfigPathConfigurer;
import org.archive.spring.PathSharingContext;
import org.archive.util.ArchiveUtils;
import org.archive.util.TextUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.validation.Errors;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class CrawlJob
implements Comparable<CrawlJob>,
ApplicationListener<ApplicationEvent> {
    private static final Logger LOGGER = Logger.getLogger(CrawlJob.class.getName());
    protected File primaryConfig;
    protected PathSharingContext ac;
    protected int launchCount;
    protected boolean isLaunchInfoPartial;
    protected Instant lastLaunch;
    protected AlertThreadGroup alertThreadGroup;
    protected Instant xmlOkAt = Instant.ofEpochMilli(0L);
    protected Logger jobLogger;
    protected transient Handler mainJobLogHandler;
    protected transient Handler currentLaunchJobLogHandler;
    protected boolean needTeardown = false;
    protected Semaphore exportLock = new Semaphore(1);

    public CrawlJob(File cxml) {
        this.primaryConfig = cxml;
        this.isLaunchInfoPartial = false;
        this.scanJobLog();
    }

    public File getPrimaryConfig() {
        return this.primaryConfig;
    }

    public File getJobDir() {
        return this.getPrimaryConfig().getParentFile();
    }

    public String getShortName() {
        return this.getJobDir().getName();
    }

    public File getJobLog() {
        return new File(this.getJobDir(), "job.log");
    }

    public synchronized PathSharingContext getJobContext() {
        return this.ac;
    }

    public boolean isLaunchInfoPartial() {
        return this.isLaunchInfoPartial;
    }

    public Logger getJobLogger() {
        if (this.jobLogger == null) {
            this.jobLogger = Logger.getLogger(this.getShortName());
            try {
                this.mainJobLogHandler = new FileHandler(this.getJobLog().getAbsolutePath(), true);
                this.mainJobLogHandler.setFormatter(new JobLogFormatter());
                this.jobLogger.addHandler(this.mainJobLogHandler);
            }
            catch (SecurityException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.jobLogger.setLevel(Level.INFO);
        }
        return this.jobLogger;
    }

    public Instant getLastLaunch() {
        return this.lastLaunch;
    }

    public int getLaunchCount() {
        return this.launchCount;
    }

    protected void scanJobLog() {
        File jobLog = this.getJobLog();
        this.launchCount = 0;
        if (!jobLog.exists()) {
            return;
        }
        try {
            String line;
            Pattern launchLine = Pattern.compile("(\\S+) (\\S+) Job launched");
            long startPosition = 0L;
            if (jobLog.length() > 102400L) {
                this.isLaunchInfoPartial = true;
                startPosition = jobLog.length() - 102400L;
            }
            FileInputStream jobLogIn = new FileInputStream(jobLog);
            jobLogIn.getChannel().position(startPosition);
            BufferedReader jobLogReader = new BufferedReader(new InputStreamReader(jobLogIn));
            if (startPosition != 0L) {
                String string = jobLogReader.readLine();
            }
            while ((line = jobLogReader.readLine()) != null) {
                Matcher m = launchLine.matcher(line);
                if (!m.matches()) continue;
                ++this.launchCount;
                this.lastLaunch = Instant.parse(m.group(1));
            }
            jobLogReader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public boolean isProfile() {
        return this.primaryConfig.getName().startsWith("profile-");
    }

    public void writeHtmlTo(PrintWriter pw) {
        this.writeHtmlTo(pw, "./");
    }

    public void writeHtmlTo(PrintWriter pw, String uriPrefix) {
        pw.println("<div>");
        pw.println("<a href='" + uriPrefix + TextUtils.urlEscape((String)this.getShortName()) + "'>" + this.getShortName() + "</a>");
        if (this.isProfile()) {
            pw.println("(profile)");
        }
        if (this.hasApplicationContext()) {
            pw.println("&laquo;" + this.getJobStatusDescription() + "&raquo;");
        }
        if (this.isLaunchInfoPartial) {
            pw.print(" at least ");
        } else {
            pw.print(" ");
        }
        pw.println(this.getLaunchCount() + " launches");
        pw.println("</div>");
        pw.println("<div style='color:#666'>");
        pw.println(this.getPrimaryConfig());
        pw.println("</div>");
        if (this.lastLaunch != null) {
            pw.println("<div>(last at " + this.lastLaunch + ")</div>");
        }
    }

    public void checkXML() {
        Instant testTime = Instant.ofEpochMilli(this.getPrimaryConfig().lastModified());
        Document doc = this.getDomDocument(this.getPrimaryConfig());
        this.xmlOkAt = doc != null ? testTime : Instant.ofEpochMilli(0L);
    }

    protected Document getDomDocument(File f) {
        try {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            return docBuilder.parse(f);
        }
        catch (ParserConfigurationException e) {
            return null;
        }
        catch (SAXException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
    }

    public boolean isXmlOk() {
        return this.xmlOkAt.toEpochMilli() >= this.getPrimaryConfig().lastModified();
    }

    public synchronized void instantiateContainer() {
        this.checkXML();
        if (this.ac == null) {
            try {
                this.ac = new PathSharingContext(new String[]{this.primaryConfig.toURI().toString()}, false, null);
                this.ac.addApplicationListener((ApplicationListener)this);
                this.ac.refresh();
                this.getCrawlController();
                this.getJobLogger().log(Level.INFO, "Job instantiated");
            }
            catch (BeansException be) {
                this.ac = null;
                this.beansException(be);
            }
        }
    }

    protected void beansException(BeansException be) {
        LinkedList<String> beMsgs = new LinkedList<String>();
        for (Throwable t = be; t != null; t = t.getCause()) {
            String msg;
            if (!(t instanceof BeansException) || (msg = this.shortMessage((BeansException)t)) == null) continue;
            beMsgs.add(msg);
        }
        Collections.reverse(beMsgs);
        String shortMessage = StringUtils.join(beMsgs, (String)"; ");
        this.getJobLogger().log(Level.SEVERE, shortMessage, be);
    }

    protected String shortMessage(BeansException ex) {
        if (ex instanceof NoSuchBeanDefinitionException) {
            NoSuchBeanDefinitionException nsbde = (NoSuchBeanDefinitionException)ex;
            return "Missing required bean: " + (nsbde.getBeanName() != null ? "\"" + nsbde.getBeanName() + "\" " : "") + (nsbde.getBeanType() != null ? "\"" + nsbde.getBeanType() + "\" " : "");
        }
        if (ex instanceof BeanCreationException) {
            BeanCreationException bce = (BeanCreationException)ex;
            return bce.getBeanName() == null ? "" : "Can't create bean '" + bce.getBeanName() + "'";
        }
        return ex.getMessage().replace('\n', ' ');
    }

    public synchronized boolean hasApplicationContext() {
        return this.ac != null;
    }

    public synchronized void validateConfiguration() {
        this.instantiateContainer();
        if (this.ac == null) {
            return;
        }
        this.ac.validate();
        HashMap allErrors = this.ac.getAllErrors();
        for (String name : allErrors.keySet()) {
            for (Object err : ((Errors)allErrors.get(name)).getAllErrors()) {
                LOGGER.log(Level.WARNING, err.toString());
            }
        }
    }

    public synchronized boolean hasValidApplicationContext() {
        if (this.ac == null) {
            return false;
        }
        HashMap allErrors = this.ac.getAllErrors();
        return allErrors != null && allErrors.isEmpty();
    }

    public void launch() {
        if (this.isProfile()) {
            throw new IllegalArgumentException("Can't launch profile" + this);
        }
        if (this.isRunning()) {
            this.getJobLogger().log(Level.SEVERE, "Can't relaunch running job");
            return;
        }
        CrawlController cc = this.getCrawlController();
        if (cc != null && cc.hasStarted()) {
            this.getJobLogger().log(Level.SEVERE, "Can't relaunch previously-launched assembled job");
            return;
        }
        this.validateConfiguration();
        if (!this.hasValidApplicationContext()) {
            this.getJobLogger().log(Level.SEVERE, "Can't launch problem configuration");
            return;
        }
        this.alertThreadGroup = new AlertThreadGroup(this.getShortName());
        this.alertThreadGroup.addLogger(this.getJobLogger());
        Thread launcher = new Thread(this.alertThreadGroup, this.getShortName() + " launchthread"){

            @Override
            public void run() {
                CrawlController cc = CrawlJob.this.getCrawlController();
                CrawlJob.this.startContext();
                if (cc != null) {
                    cc.requestCrawlStart();
                }
            }
        };
        this.getJobLogger().log(Level.INFO, "Job launched");
        this.scanJobLog();
        launcher.start();
        try {
            launcher.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected synchronized void startContext() {
        try {
            this.ac.start();
            this.getJobLogger().removeHandler(this.currentLaunchJobLogHandler);
            File f = new File(this.ac.getCurrentLaunchDir(), "job.log");
            this.currentLaunchJobLogHandler = new FileHandler(f.getAbsolutePath(), true);
            this.currentLaunchJobLogHandler.setFormatter(new JobLogFormatter());
            this.getJobLogger().addHandler(this.currentLaunchJobLogHandler);
        }
        catch (BeansException be) {
            this.doTeardown();
            this.beansException(be);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getClass().getSimpleName() + ": " + e.getMessage(), e);
            try {
                this.doTeardown();
            }
            catch (Exception e2) {
                e2.printStackTrace(System.err);
            }
        }
    }

    @Override
    public int compareTo(CrawlJob o) {
        return -Long.valueOf(this.getLastActivityTime()).compareTo(o.getLastActivityTime());
    }

    public long getLastActivityTime() {
        return Math.max(this.getPrimaryConfig().lastModified(), this.getJobLog().lastModified());
    }

    public synchronized boolean isRunning() {
        return this.ac != null && this.ac.isActive() && this.ac.isRunning();
    }

    public synchronized CrawlController getCrawlController() {
        if (this.ac == null) {
            return null;
        }
        return (CrawlController)this.ac.getBean("crawlController");
    }

    public boolean isPausable() {
        CrawlController cc = this.getCrawlController();
        if (cc == null) {
            return false;
        }
        return cc.isActive();
    }

    public boolean isUnpausable() {
        CrawlController cc = this.getCrawlController();
        if (cc == null) {
            return false;
        }
        return cc.isPaused() || cc.isPausing();
    }

    public synchronized CheckpointService getCheckpointService() {
        if (this.ac == null) {
            return null;
        }
        Map beans = this.getJobContext().getBeansOfType(CheckpointService.class);
        return beans.size() == 1 ? (CheckpointService)beans.values().iterator().next() : null;
    }

    public synchronized boolean teardown() {
        CrawlController cc = this.getCrawlController();
        if (cc != null) {
            cc.requestCrawlStop();
            this.needTeardown = true;
            for (int i = 0; i < 11 && !cc.isStopComplete(); ++i) {
                try {
                    Thread.sleep(300L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            if (cc.isStopComplete()) {
                this.doTeardown();
            }
        }
        assert (this.needTeardown == (this.ac != null));
        return !this.needTeardown;
    }

    protected synchronized void doTeardown() {
        this.needTeardown = false;
        try {
            if (this.ac != null) {
                this.ac.close();
            }
        }
        finally {
            this.ac = null;
            this.xmlOkAt = Instant.ofEpochMilli(0L);
            if (this.currentLaunchJobLogHandler != null) {
                this.getJobLogger().removeHandler(this.currentLaunchJobLogHandler);
                this.currentLaunchJobLogHandler.close();
                this.currentLaunchJobLogHandler = null;
            }
            this.getJobLogger().log(Level.INFO, "Job instance discarded");
            if (this.mainJobLogHandler != null) {
                this.getJobLogger().removeHandler(this.mainJobLogHandler);
                this.mainJobLogHandler.close();
                this.mainJobLogHandler = null;
            }
            this.jobLogger = null;
        }
    }

    public List<File> getImportedConfigs(File xml) {
        LinkedList<File> imports = new LinkedList<File>();
        Document doc = this.getDomDocument(xml);
        if (doc == null) {
            return ListUtils.EMPTY_LIST;
        }
        NodeList importElements = doc.getElementsByTagName("import");
        for (int i = 0; i < importElements.getLength(); ++i) {
            File imported = new File(this.getJobDir(), importElements.item(i).getAttributes().getNamedItem("resource").getTextContent());
            imports.add(imported);
            imports.addAll(this.getImportedConfigs(imported));
        }
        return imports;
    }

    public synchronized Map<String, ConfigPath> getConfigPaths() {
        if (this.ac == null) {
            return MapUtils.EMPTY_MAP;
        }
        ConfigPathConfigurer cpc = (ConfigPathConfigurer)this.ac.getBean("configPathConfigurer");
        return cpc.getAllConfigPaths();
    }

    public String jobDirRelativePath(File f) {
        try {
            String filePath = f.getCanonicalPath();
            String jobPath = this.getJobDir().getCanonicalPath();
            if (filePath.startsWith(jobPath)) {
                String jobRelative = filePath.substring(jobPath.length()).replace(File.separatorChar, '/');
                if (jobRelative.startsWith("/")) {
                    jobRelative = jobRelative.substring(1);
                }
                return jobRelative;
            }
        }
        catch (IOException e) {
            this.getJobLogger().log(Level.WARNING, "bad file: " + f);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(ApplicationEvent event) {
        if (event instanceof CrawlStateEvent) {
            this.getJobLogger().log(Level.INFO, (Object)((Object)((CrawlStateEvent)event).getState()) + (this.ac.getCurrentLaunchId() != null ? " " + this.ac.getCurrentLaunchId() : ""));
        }
        if (event instanceof CrawlController.StopCompleteEvent) {
            CrawlJob crawlJob = this;
            synchronized (crawlJob) {
                if (this.needTeardown) {
                    this.doTeardown();
                }
            }
        }
        if (event instanceof CheckpointSuccessEvent) {
            this.getJobLogger().log(Level.INFO, "CHECKPOINTED " + ((CheckpointSuccessEvent)event).getCheckpoint().getName());
        }
    }

    public boolean isLaunchable() {
        if (!this.hasApplicationContext()) {
            return true;
        }
        if (!this.hasValidApplicationContext()) {
            return false;
        }
        CrawlController cc = this.getCrawlController();
        return cc == null || !cc.hasStarted();
    }

    public int getAlertCount() {
        if (this.alertThreadGroup != null) {
            return this.alertThreadGroup.getAlertCount();
        }
        return 0;
    }

    protected StatisticsTracker getStats() {
        CrawlController cc = this.getCrawlController();
        return cc != null ? cc.getStatisticsTracker() : null;
    }

    public Map<String, Number> rateReportData() {
        StatisticsTracker stats = this.getStats();
        if (stats == null) {
            return null;
        }
        CrawlStatSnapshot snapshot = stats.getSnapshot();
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        map.put("currentDocsPerSecond", snapshot.currentDocsPerSecond);
        map.put("averageDocsPerSecond", snapshot.docsPerSecond);
        map.put("currentKiBPerSec", snapshot.currentKiBPerSec);
        map.put("averageKiBPerSec", snapshot.totalKiBPerSec);
        return map;
    }

    public Object rateReport() {
        StatisticsTracker stats = this.getStats();
        if (stats == null) {
            return "<i>n/a</i>";
        }
        CrawlStatSnapshot snapshot = stats.getSnapshot();
        StringBuilder sb = new StringBuilder();
        sb.append(ArchiveUtils.doubleToString((double)snapshot.currentDocsPerSecond, (int)2)).append(" URIs/sec (").append(ArchiveUtils.doubleToString((double)snapshot.docsPerSecond, (int)2)).append(" avg); ").append(snapshot.currentKiBPerSec).append(" KB/sec (").append(snapshot.totalKiBPerSec).append(" avg)");
        return sb.toString();
    }

    public Map<String, Number> loadReportData() {
        StatisticsTracker stats = this.getStats();
        if (stats == null) {
            return null;
        }
        CrawlStatSnapshot snapshot = stats.getSnapshot();
        LinkedHashMap<String, Number> map = new LinkedHashMap<String, Number>();
        map.put("busyThreads", snapshot.busyThreads);
        map.put("totalThreads", stats.threadCount());
        map.put("congestionRatio", Float.valueOf(snapshot.congestionRatio));
        map.put("averageQueueDepth", snapshot.averageDepth);
        map.put("deepestQueueDepth", snapshot.deepestUri);
        return map;
    }

    public Object loadReport() {
        StatisticsTracker stats = this.getStats();
        if (stats == null) {
            return "<i>n/a</i>";
        }
        CrawlStatSnapshot snapshot = stats.getSnapshot();
        StringBuilder sb = new StringBuilder();
        sb.append(snapshot.busyThreads).append(" active of ").append(stats.threadCount()).append(" threads; ").append(ArchiveUtils.doubleToString((double)snapshot.congestionRatio, (int)2)).append(" congestion ratio; ").append(snapshot.deepestUri).append("  deepest queue; ").append(snapshot.averageDepth).append("  average depth");
        return sb.toString();
    }

    public Map<String, Long> uriTotalsReportData() {
        StatisticsTracker stats = this.getStats();
        if (stats == null) {
            return null;
        }
        CrawlStatSnapshot snapshot = stats.getSnapshot();
        LinkedHashMap<String, Long> totals = new LinkedHashMap<String, Long>();
        totals.put("downloadedUriCount", snapshot.downloadedUriCount);
        totals.put("queuedUriCount", snapshot.queuedUriCount);
        totals.put("totalUriCount", snapshot.totalCount());
        totals.put("futureUriCount", snapshot.futureUriCount);
        return totals;
    }

    public String uriTotalsReport() {
        Map<String, Long> uriTotals = this.uriTotalsReportData();
        if (uriTotals == null) {
            return "<i>n/a</i>";
        }
        StringBuilder sb = new StringBuilder(64);
        sb.append(uriTotals.get("downloadedUriCount")).append(" downloaded + ").append(uriTotals.get("queuedUriCount")).append(" queued = ").append(uriTotals.get("totalUriCount")).append(" total");
        if (uriTotals.get("futureUriCount") > 0L) {
            sb.append(" (").append(uriTotals.get("futureUriCount")).append(" future)");
        }
        return sb.toString();
    }

    public Map<String, Long> sizeTotalsReportData() {
        StatisticsTracker stats = this.getStats();
        if (stats == null) {
            return null;
        }
        TreeMap<String, Long> map = new TreeMap<String, Long>((SortedMap<String, Long>)stats.getCrawledBytes());
        map.put("total", stats.getCrawledBytes().getTotalBytes());
        map.put("totalCount", stats.getCrawledBytes().getTotalUrls());
        return map;
    }

    public String sizeTotalsReport() {
        StatisticsTracker stats = this.getStats();
        if (stats == null) {
            return "<i>n/a</i>";
        }
        return stats.crawledBytesSummary();
    }

    public Map<String, Object> elapsedReportData() {
        StatisticsTracker stats = this.getStats();
        if (stats == null) {
            return null;
        }
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        long timeElapsed = stats.getCrawlElapsedTime();
        map.put("elapsedMilliseconds", timeElapsed);
        map.put("elapsedPretty", ArchiveUtils.formatMillisecondsToConventional((long)timeElapsed));
        return map;
    }

    public String elapsedReport() {
        StatisticsTracker stats = this.getStats();
        if (stats == null) {
            return "<i>n/a</i>";
        }
        long timeElapsed = stats.getCrawlElapsedTime();
        return ArchiveUtils.formatMillisecondsToConventional((long)timeElapsed);
    }

    public Map<String, Object> threadReportData() {
        CrawlController cc = this.getCrawlController();
        if (cc == null) {
            return null;
        }
        return cc.getToeThreadReportShortData();
    }

    public String threadReport() {
        CrawlController cc = this.getCrawlController();
        if (cc == null) {
            return "<i>n/a</i>";
        }
        return cc.getToeThreadReportShort();
    }

    public Map<String, Object> frontierReportData() {
        CrawlController cc = this.getCrawlController();
        if (cc == null) {
            return null;
        }
        return cc.getFrontier().shortReportMap();
    }

    public String frontierReport() {
        CrawlController cc = this.getCrawlController();
        if (cc == null) {
            return "<i>n/a</i>";
        }
        return cc.getFrontierReportShort();
    }

    public void terminate() {
        if (this.getCrawlController() != null) {
            this.getCrawlController().requestCrawlStop();
        }
    }

    public Object getBeanpathTarget(String beanPath) {
        try {
            int i = beanPath.indexOf(".");
            String beanName = i < 0 ? beanPath : beanPath.substring(0, i);
            Object namedBean = this.ac.getBean(beanName);
            if (i < 0) {
                return namedBean;
            }
            BeanWrapperImpl bwrap = new BeanWrapperImpl(namedBean);
            String propPath = beanPath.substring(i + 1);
            return bwrap.getPropertyValue(propPath);
        }
        catch (BeansException e) {
            return null;
        }
    }

    public String getJobStatusDescription() {
        if (!this.hasApplicationContext()) {
            return "Unbuilt";
        }
        if (this.isRunning()) {
            if (!this.getCrawlController().isRunning()) {
                return "Not running: " + (Object)((Object)this.getCrawlController().getCrawlExitStatus());
            }
            return "Active: " + this.getCrawlController().getState();
        }
        if (this.isLaunchable()) {
            return "Ready";
        }
        return "Finished: " + (Object)((Object)this.getCrawlController().getCrawlExitStatus());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long exportPendingUris() {
        CrawlController cc = this.getCrawlController();
        if (cc == null) {
            return -1L;
        }
        if (!cc.isPaused()) {
            cc.requestCrawlPause();
            return -2L;
        }
        Frontier f = cc.getFrontier();
        if (f == null) {
            return -3L;
        }
        long pendingUrisCount = 0L;
        boolean bLocked = this.exportLock.tryAcquire();
        if (bLocked) {
            try {
                File outFile = new File(this.getJobDir(), "pendingUris.txt");
                if (outFile.exists()) {
                    outFile.delete();
                }
                FileOutputStream out = new FileOutputStream(outFile);
                OutputStreamWriter outStreamWriter = new OutputStreamWriter((OutputStream)out, StandardCharsets.UTF_8);
                PrintWriter writer = new PrintWriter(new BufferedWriter(outStreamWriter, 65536));
                pendingUrisCount = f.exportPendingUris(writer);
                writer.close();
                outStreamWriter.close();
                out.close();
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, e.getMessage(), e);
            }
            finally {
                this.exportLock.release();
            }
        } else {
            return -4L;
        }
        return pendingUrisCount;
    }

    public class JobLogFormatter
    extends Formatter {
        @Override
        public String format(LogRecord record) {
            StringBuilder sb = new StringBuilder();
            sb.append(Instant.ofEpochMilli(record.getMillis())).append(" ").append(record.getLevel()).append(" ").append(record.getMessage()).append("\n");
            return sb.toString();
        }
    }
}

